/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.oops.NamedFieldIdentifier;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class java_lang_Class {
    static int klassOffset;
    static IntField oopSizeField;

    private static synchronized void initialize(TypeDataBase db) {
        Type jlc = db.lookupType("java_lang_Class");
        klassOffset = (int)jlc.getCIntegerField("_klass_offset").getValue();
        int oopSizeOffset = (int)jlc.getCIntegerField("_oop_size_offset").getValue();
        oopSizeField = new IntField(new NamedFieldIdentifier("oop_size"), oopSizeOffset, true);
    }

    public static Klass asKlass(Oop aClass) {
        return (Klass)Metadata.instantiateWrapperFor(aClass.getHandle().getAddressAt(klassOffset));
    }

    public static long getOopSize(Oop aClass) {
        return oopSizeField.getValue(aClass);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                java_lang_Class.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

