/*
 * Decompiled with CFR 0.152.
 */
package jdk.net;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import jdk.Exported;
import jdk.net.ExtendedSocketOptions;
import sun.net.ExtendedOptionsHelper;
import sun.net.ExtendedOptionsImpl;

@Exported
public class Sockets {
    private static final HashMap<Class<?>, Set<SocketOption<?>>> options = new HashMap();
    private static Method siSetOption;
    private static Method siGetOption;
    private static Method dsiSetOption;
    private static Method dsiGetOption;

    private static void initMethods() {
        try {
            Class<?> clazz = Class.forName("java.net.SocketSecrets");
            siSetOption = clazz.getDeclaredMethod("setOption", Object.class, SocketOption.class, Object.class);
            siSetOption.setAccessible(true);
            siGetOption = clazz.getDeclaredMethod("getOption", Object.class, SocketOption.class);
            siGetOption.setAccessible(true);
            dsiSetOption = clazz.getDeclaredMethod("setOption", DatagramSocket.class, SocketOption.class, Object.class);
            dsiSetOption.setAccessible(true);
            dsiGetOption = clazz.getDeclaredMethod("getOption", DatagramSocket.class, SocketOption.class);
            dsiGetOption.setAccessible(true);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException);
        }
    }

    private static <T> void invokeSet(Method method, Object object, SocketOption<T> socketOption, T t) throws IOException {
        try {
            method.invoke(null, object, socketOption, t);
        }
        catch (Exception exception) {
            if (exception instanceof InvocationTargetException) {
                Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
            }
            throw new RuntimeException(exception);
        }
    }

    private static <T> T invokeGet(Method method, Object object, SocketOption<T> socketOption) throws IOException {
        try {
            return (T)method.invoke(null, object, socketOption);
        }
        catch (Exception exception) {
            if (exception instanceof InvocationTargetException) {
                Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
            }
            throw new RuntimeException(exception);
        }
    }

    private Sockets() {
    }

    public static <T> void setOption(Socket socket, SocketOption<T> socketOption, T t) throws IOException {
        if (!Sockets.isSupported(Socket.class, socketOption)) {
            throw new UnsupportedOperationException(socketOption.name());
        }
        Sockets.invokeSet(siSetOption, socket, socketOption, t);
    }

    public static <T> T getOption(Socket socket, SocketOption<T> socketOption) throws IOException {
        if (!Sockets.isSupported(Socket.class, socketOption)) {
            throw new UnsupportedOperationException(socketOption.name());
        }
        return Sockets.invokeGet(siGetOption, socket, socketOption);
    }

    public static <T> void setOption(ServerSocket serverSocket, SocketOption<T> socketOption, T t) throws IOException {
        if (!Sockets.isSupported(ServerSocket.class, socketOption)) {
            throw new UnsupportedOperationException(socketOption.name());
        }
        Sockets.invokeSet(siSetOption, serverSocket, socketOption, t);
    }

    public static <T> T getOption(ServerSocket serverSocket, SocketOption<T> socketOption) throws IOException {
        if (!Sockets.isSupported(ServerSocket.class, socketOption)) {
            throw new UnsupportedOperationException(socketOption.name());
        }
        return Sockets.invokeGet(siGetOption, serverSocket, socketOption);
    }

    public static <T> void setOption(DatagramSocket datagramSocket, SocketOption<T> socketOption, T t) throws IOException {
        if (!Sockets.isSupported(datagramSocket.getClass(), socketOption)) {
            throw new UnsupportedOperationException(socketOption.name());
        }
        Sockets.invokeSet(dsiSetOption, datagramSocket, socketOption, t);
    }

    public static <T> T getOption(DatagramSocket datagramSocket, SocketOption<T> socketOption) throws IOException {
        if (!Sockets.isSupported(datagramSocket.getClass(), socketOption)) {
            throw new UnsupportedOperationException(socketOption.name());
        }
        return Sockets.invokeGet(dsiGetOption, datagramSocket, socketOption);
    }

    public static Set<SocketOption<?>> supportedOptions(Class<?> clazz) {
        Set<SocketOption<?>> set = options.get(clazz);
        if (set == null) {
            throw new IllegalArgumentException("unknown socket type");
        }
        return set;
    }

    private static boolean isSupported(Class<?> clazz, SocketOption<?> socketOption) {
        Set<SocketOption<?>> set = Sockets.supportedOptions(clazz);
        return set.contains(socketOption);
    }

    private static void initOptionSets() {
        boolean bl = ExtendedOptionsImpl.flowSupported();
        Set<SocketOption<Boolean>> set = new HashSet();
        set.add(StandardSocketOptions.SO_KEEPALIVE);
        set.add(StandardSocketOptions.SO_SNDBUF);
        set.add(StandardSocketOptions.SO_RCVBUF);
        set.add(StandardSocketOptions.SO_REUSEADDR);
        set.add(StandardSocketOptions.SO_LINGER);
        set.add(StandardSocketOptions.IP_TOS);
        set.add(StandardSocketOptions.TCP_NODELAY);
        if (bl) {
            set.add(ExtendedSocketOptions.SO_FLOW_SLA);
        }
        set.addAll(ExtendedOptionsHelper.keepAliveOptions());
        set = Collections.unmodifiableSet(set);
        options.put(Socket.class, set);
        set = new HashSet();
        set.add(StandardSocketOptions.SO_RCVBUF);
        set.add(StandardSocketOptions.SO_REUSEADDR);
        set.add(StandardSocketOptions.IP_TOS);
        set.addAll(ExtendedOptionsHelper.keepAliveOptions());
        set = Collections.unmodifiableSet(set);
        options.put(ServerSocket.class, set);
        set = new HashSet();
        set.add(StandardSocketOptions.SO_SNDBUF);
        set.add(StandardSocketOptions.SO_RCVBUF);
        set.add(StandardSocketOptions.SO_REUSEADDR);
        set.add(StandardSocketOptions.IP_TOS);
        if (bl) {
            set.add(ExtendedSocketOptions.SO_FLOW_SLA);
        }
        set = Collections.unmodifiableSet(set);
        options.put(DatagramSocket.class, set);
        set = new HashSet();
        set.add(StandardSocketOptions.SO_SNDBUF);
        set.add(StandardSocketOptions.SO_RCVBUF);
        set.add(StandardSocketOptions.SO_REUSEADDR);
        set.add(StandardSocketOptions.IP_TOS);
        set.add(StandardSocketOptions.IP_MULTICAST_IF);
        set.add(StandardSocketOptions.IP_MULTICAST_TTL);
        set.add(StandardSocketOptions.IP_MULTICAST_LOOP);
        if (bl) {
            set.add(ExtendedSocketOptions.SO_FLOW_SLA);
        }
        set = Collections.unmodifiableSet(set);
        options.put(MulticastSocket.class, set);
    }

    static {
        Sockets.initOptionSets();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Sockets.initMethods();
                return null;
            }
        });
    }
}

