/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.property;

import java.util.ArrayList;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceLogLevel;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.BaseEventComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.property.BasePropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class BaseEventPropertySource
extends BasePropertySource {
    public static final String BASE_EVENT_NAME_PROPERTY_ID = "base.event.name";
    public static final String BASE_EVENT_TYPE_PROPERTY_ID = "base.event.type";
    public static final String BASE_EVENT_LOGLEVEL_PROPERTY_ID = "base.event.loglevel";
    public static final String BASE_EVENT_NAME_PROPERTY_NAME = Messages.TraceControl_EventNamePropertyName;
    public static final String BASE_EVENT_TYPE_PROPERTY_NAME = Messages.TraceControl_EventTypePropertyName;
    public static final String BASE_EVENT_LOGLEVEL_PROPERTY_NAME = Messages.TraceControl_LogLevelPropertyName;
    private final BaseEventComponent fBaseEvent;

    public BaseEventPropertySource(BaseEventComponent component) {
        this.fBaseEvent = component;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<TextPropertyDescriptor> list = new ArrayList<TextPropertyDescriptor>();
        list.add(new TextPropertyDescriptor((Object)BASE_EVENT_NAME_PROPERTY_ID, BASE_EVENT_NAME_PROPERTY_NAME));
        list.add(new TextPropertyDescriptor((Object)BASE_EVENT_TYPE_PROPERTY_ID, BASE_EVENT_TYPE_PROPERTY_NAME));
        if (this.fBaseEvent.getLogLevel() != TraceLogLevel.LEVEL_UNKNOWN) {
            list.add(new TextPropertyDescriptor((Object)BASE_EVENT_LOGLEVEL_PROPERTY_ID, BASE_EVENT_LOGLEVEL_PROPERTY_NAME));
        }
        return list.toArray(new IPropertyDescriptor[list.size()]);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (BASE_EVENT_NAME_PROPERTY_ID.equals(id)) {
            return this.fBaseEvent.getName();
        }
        if (BASE_EVENT_TYPE_PROPERTY_ID.equals(id)) {
            return this.fBaseEvent.getEventType().name();
        }
        if (BASE_EVENT_LOGLEVEL_PROPERTY_ID.equals(id)) {
            return this.fBaseEvent.getLogLevel().name();
        }
        return null;
    }
}

