/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.ControlView;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.INewConnectionDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.TraceControlDialogFactory;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.handlers.BaseControlViewHandler;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.ITraceControlComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TargetNodeComponent;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NewConnectionHandler
extends BaseControlViewHandler {
    public static final String TRACE_CONTROL_SYSTEM_TYPE = "org.eclipse.linuxtools.internal.lttng2.ui.control.systemType";
    private ITraceControlComponent fRoot = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        assert (this.fRoot != null);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        IRSESystemType sysType = RSECorePlugin.getTheCoreRegistry().getSystemTypeById(TRACE_CONTROL_SYSTEM_TYPE);
        IHost[] hosts = registry.getHostsBySystemType(sysType);
        INewConnectionDialog dialog = TraceControlDialogFactory.getInstance().getNewConnectionDialog();
        dialog.setTraceControlParent(this.fRoot);
        dialog.setHosts(hosts);
        if (dialog.open() != 0) {
            return null;
        }
        String hostName = dialog.getConnectionName();
        String hostAddress = dialog.getHostName();
        IHost host = null;
        int i = 0;
        while (i < hosts.length) {
            if (hosts[i].getAliasName().equals(hostName)) {
                host = hosts[i];
                break;
            }
            ++i;
        }
        if (host == null) {
            try {
                host = registry.createHost(sysType, hostName, hostAddress, "Connection to Host");
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)window.getShell(), (String)Messages.TraceControl_EclipseCommandFailure, (String)(String.valueOf(Messages.TraceControl_NewNodeCreationFailure) + " (" + hostName + ", " + hostAddress + ")" + ":\n" + e.toString()));
                return null;
            }
        }
        if (host != null) {
            this.fLock.lock();
            try {
                TargetNodeComponent node = null;
                if (!this.fRoot.containsChild(hostName)) {
                    node = new TargetNodeComponent(hostName, this.fRoot, host);
                    this.fRoot.addChild(node);
                } else {
                    node = (TargetNodeComponent)this.fRoot.getChild(hostName);
                }
                node.connect();
            }
            finally {
                this.fLock.unlock();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        ITraceControlComponent root = null;
        IWorkbenchPart part = page.getActivePart();
        root = ((ControlView)part).getTraceControlRoot();
        boolean isEnabled = root != null;
        this.fLock.lock();
        try {
            this.fRoot = null;
            if (isEnabled) {
                this.fRoot = root;
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }
}

