/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.core.state.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.linuxtools.internal.lttng.core.state.LttngStateException;
import org.eclipse.linuxtools.internal.lttng.core.state.StateStrings;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LTTngCPUState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngBdevState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngExecutionState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngIRQState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngProcessState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngSoftIRQState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngTrapState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.ProcessStateKey;
import org.eclipse.linuxtools.internal.lttng.core.state.resource.ILttngStateContext;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;

public class LttngTraceState
implements Cloneable {
    private Long save_interval = null;
    private Long max_time_state_recomputed_in_seek = null;
    private boolean has_precomputed_states = false;
    private HashMap<ProcessStateKey, LttngProcessState> processes = new HashMap();
    private Map<Long, LttngProcessState> running_process = new HashMap<Long, LttngProcessState>();
    private Map<Long, LTTngCPUState> cpu_states = new HashMap<Long, LTTngCPUState>();
    private Map<Long, LttngIRQState> irq_states = new HashMap<Long, LttngIRQState>();
    private Map<Long, LttngSoftIRQState> soft_irq_states = new HashMap<Long, LttngSoftIRQState>();
    private Map<Long, LttngTrapState> trap_states = new HashMap<Long, LttngTrapState>();
    private Map<Long, LttngBdevState> bdev_states = new HashMap<Long, LttngBdevState>();
    private Map<Long, String> syscall_names = new HashMap<Long, String>();
    private Map<Long, String> kprobe_table = new HashMap<Long, String>();
    private Map<Long, String> soft_irq_names = new HashMap<Long, String>();
    private Map<Long, String> trap_names = new HashMap<Long, String>();
    private Map<Long, String> irq_names = new HashMap<Long, String>();
    private int nb_events = 0;
    ILttngStateContext fContext = null;
    String traceId = "";

    LttngTraceState() {
        StateStrings strings = StateStrings.getInstance();
        String[] ref_name_table = strings.getSyscallNames();
        Long i = 0L;
        while (i < (long)ref_name_table.length) {
            this.syscall_names.put(i, ref_name_table[i.intValue()]);
            i = i + 1L;
        }
        ref_name_table = strings.getTrapNames();
        i = 0L;
        while (i < (long)ref_name_table.length) {
            this.trap_names.put(i, ref_name_table[i.intValue()]);
            i = i + 1L;
        }
        ref_name_table = strings.getIrqNames();
        i = 0L;
        while (i < (long)ref_name_table.length) {
            this.irq_names.put(i, ref_name_table[i.intValue()]);
            i = i + 1L;
        }
        ref_name_table = strings.getSoftIrqNames();
        i = 0L;
        while (i < (long)ref_name_table.length) {
            this.soft_irq_names.put(i, ref_name_table[i.intValue()]);
            i = i + 1L;
        }
    }

    public LttngTraceState clone() {
        LttngTraceState newState = null;
        try {
            newState = (LttngTraceState)super.clone();
            newState.save_interval = this.save_interval;
            newState.traceId = this.traceId;
            newState.has_precomputed_states = this.has_precomputed_states;
            newState.nb_events = this.nb_events;
            newState.max_time_state_recomputed_in_seek = this.max_time_state_recomputed_in_seek;
            newState.syscall_names = this.syscall_names;
            newState.kprobe_table = this.kprobe_table;
            newState.soft_irq_names = this.soft_irq_names;
            newState.trap_names = this.trap_names;
            newState.irq_names = this.irq_names;
            newState.fContext = this.fContext;
            Iterator<Long> iteratorL = null;
            Iterator<ProcessStateKey> iteratorP = null;
            Long mapKey2 = null;
            ProcessStateKey processKey2 = null;
            newState.processes = new HashMap();
            for (ProcessStateKey processKey2 : this.processes.keySet()) {
                newState.processes.put(processKey2, this.processes.get(processKey2).clone());
            }
            newState.running_process = new HashMap<Long, LttngProcessState>();
            for (Long mapKey2 : this.running_process.keySet()) {
                newState.running_process.put(mapKey2, this.running_process.get(mapKey2).clone());
            }
            newState.cpu_states = new HashMap<Long, LTTngCPUState>();
            for (Long mapKey2 : this.cpu_states.keySet()) {
                newState.cpu_states.put(mapKey2, this.cpu_states.get(mapKey2).clone());
            }
            newState.irq_states = new HashMap<Long, LttngIRQState>();
            for (Long mapKey2 : this.irq_states.keySet()) {
                newState.irq_states.put(mapKey2, this.irq_states.get(mapKey2).clone());
            }
            newState.soft_irq_states = new HashMap<Long, LttngSoftIRQState>();
            for (Long mapKey2 : this.soft_irq_states.keySet()) {
                newState.soft_irq_states.put(mapKey2, this.soft_irq_states.get(mapKey2).clone());
            }
            newState.trap_states = new HashMap<Long, LttngTrapState>();
            for (Long mapKey2 : this.trap_states.keySet()) {
                newState.trap_states.put(mapKey2, this.trap_states.get(mapKey2).clone());
            }
            newState.bdev_states = new HashMap<Long, LttngBdevState>();
            for (Long mapKey2 : this.bdev_states.keySet()) {
                newState.bdev_states.put(mapKey2, this.bdev_states.get(mapKey2).clone());
            }
        }
        catch (CloneNotSupportedException e) {
            System.out.println("Cloning failed with : " + e.getMessage());
        }
        return newState;
    }

    public void init(ILttngStateContext context) throws LttngStateException {
        if (context == null) {
            StringBuilder sb = new StringBuilder("The input provider reference must not be null");
            throw new LttngStateException(sb.toString());
        }
        this.fContext = context;
        this.traceId = this.fContext.getTraceId();
        this.max_time_state_recomputed_in_seek = 0L;
        this.cpu_states.clear();
        int numCpus = this.fContext.getNumberOfCpus();
        Long i = 0L;
        while (i < (long)numCpus) {
            this.cpu_states.put(i, new LTTngCPUState());
            i = i + 1L;
        }
        this.irq_states.clear();
        i = 0L;
        while (i < (long)this.irq_names.size()) {
            this.irq_states.put(i, new LttngIRQState());
            i = i + 1L;
        }
        this.soft_irq_states.clear();
        i = 0L;
        while (i < (long)this.soft_irq_names.size()) {
            this.soft_irq_states.put(i, new LttngSoftIRQState());
            i = i + 1L;
        }
        this.trap_states.clear();
        i = 0L;
        while (i < (long)this.trap_names.size()) {
            this.trap_states.put(i, new LttngTrapState(0L));
            i = i + 1L;
        }
        this.bdev_states.clear();
        this.processes.clear();
        this.nb_events = 0;
        TmfTimeRange timeWin = this.fContext.getTraceTimeWindow();
        Long i2 = 0L;
        while (i2 < (long)numCpus) {
            LttngProcessState process = new LttngProcessState(timeWin.getStartTime().getValue(), this.traceId);
            LttngExecutionState es = process.getFirstElementFromExecutionStack();
            process.setState(es);
            es.setExec_mode(StateStrings.ExecutionMode.LTTV_STATE_MODE_UNKNOWN);
            es.setExec_submode(StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_NONE.getInName());
            es.setExec_submode_id(StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_NONE.ordinal() | 0x10000000);
            es.setProc_status(StateStrings.ProcessStatus.LTTV_STATE_UNNAMED);
            process.popFromExecutionStack();
            process.setCpu(i2);
            process.setUserTrace("");
            this.running_process.put(i2, process);
            LTTngCPUState cpuState = this.cpu_states.get(i2);
            cpuState.reset();
            this.processes.put(new ProcessStateKey(process), process);
            i2 = i2 + 1L;
        }
        for (Long key : this.irq_states.keySet()) {
            LttngIRQState irqState = this.irq_states.get(key);
            irqState.clearAndSetBaseToIrqStack(StateStrings.IRQMode.LTTV_IRQ_UNKNOWN);
        }
        for (Long key : this.soft_irq_states.keySet()) {
            LttngSoftIRQState softIrqState = this.soft_irq_states.get(key);
            softIrqState.reset();
        }
        for (Long key : this.trap_states.keySet()) {
            LttngTrapState trapState = this.trap_states.get(key);
            trapState.setRunning(0L);
        }
        for (Long key : this.bdev_states.keySet()) {
            LttngBdevState bdevState = this.bdev_states.get(key);
            bdevState.clearBdevStack();
        }
    }

    public Long getSave_interval() {
        return this.save_interval;
    }

    public void setSave_interval(Long saveInterval) {
        this.save_interval = saveInterval;
    }

    public int getNumberOfCPUs() {
        return this.fContext.getNumberOfCpus();
    }

    public ILttngStateContext getContext() {
        return this.fContext;
    }

    public Long getMax_time_state_recomputed_in_seek() {
        return this.max_time_state_recomputed_in_seek;
    }

    public void setMax_time_state_recomputed_in_seek(Long maxTimeStateRecomputedInSeek) {
        this.max_time_state_recomputed_in_seek = maxTimeStateRecomputedInSeek;
    }

    public boolean isHas_precomputed_states() {
        return this.has_precomputed_states;
    }

    public void setHas_precomputed_states(boolean hasPrecomputedStates) {
        this.has_precomputed_states = hasPrecomputedStates;
    }

    public Map<Long, LttngProcessState> getRunning_process() {
        return this.running_process;
    }

    public Map<Long, String> getSyscall_names() {
        return this.syscall_names;
    }

    public Map<Long, String> getTrap_names() {
        return this.trap_names;
    }

    public Map<Long, String> getIrq_names() {
        return this.irq_names;
    }

    public Map<Long, String> getSoft_irq_names() {
        return this.soft_irq_names;
    }

    public Map<Long, LTTngCPUState> getCpu_states() {
        return this.cpu_states;
    }

    public Map<Long, LttngIRQState> getIrq_states() {
        return this.irq_states;
    }

    public Map<Long, LttngSoftIRQState> getSoft_irq_states() {
        return this.soft_irq_states;
    }

    public Map<Long, LttngTrapState> getTrap_states() {
        return this.trap_states;
    }

    public Map<Long, LttngBdevState> getBdev_states() {
        return this.bdev_states;
    }

    public Map<Long, String> getKprobe_table() {
        return this.kprobe_table;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public LttngProcessState[] getProcesses() {
        return this.processes.values().toArray(new LttngProcessState[this.processes.size()]);
    }

    public void clearProcessState() {
        this.processes.clear();
    }

    public void addProcessState(LttngProcessState newProcessState) {
        if (newProcessState != null) {
            this.processes.put(new ProcessStateKey(newProcessState), newProcessState);
        }
    }

    public void removeProcessState(LttngProcessState oldProcessState) {
        if (oldProcessState != null) {
            this.processes.remove(new ProcessStateKey(oldProcessState));
        }
    }

    public LttngProcessState findProcessState(Long searchedPid, Long searchedCpuId, String searchedTraceID) {
        LttngProcessState foundProcess = this.processes.get(new ProcessStateKey(searchedPid, searchedCpuId, searchedTraceID));
        return foundProcess;
    }
}

