/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.internal.ctf.core.event.io.BitBuffer;

public class EnumDefinition
extends Definition {
    private final EnumDeclaration declaration;
    private final IntegerDefinition integerValue;
    private String value;

    public EnumDefinition(EnumDeclaration declaration, IDefinitionScope definitionScope, String fieldName) {
        super(definitionScope, fieldName);
        this.declaration = declaration;
        this.integerValue = declaration.getContainerType().createDefinition(definitionScope, fieldName);
        this.value = Long.valueOf(this.integerValue.getValue()).toString();
    }

    public String getValue() {
        return this.value;
    }

    public long getIntegerValue() {
        return this.integerValue.getValue();
    }

    public void setIntegerValue(long Value) {
        this.integerValue.setValue(Value);
        this.value = Long.valueOf(this.integerValue.getValue()).toString();
    }

    @Override
    public void read(BitBuffer input) {
        int align = (int)this.declaration.getAlignment();
        int pos = input.position() + (align - input.position() % align) % align;
        input.position(pos);
        this.integerValue.read(input);
        long val = this.integerValue.getValue();
        this.value = this.declaration.query(val);
    }
}

