/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core.data;

import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;

public final class TaskData {
    private final String connectorKind;
    private boolean partial;
    private String version;
    private final String repositoryUrl;
    private final String taskId;
    private final TaskAttributeMapper mapper;
    private final TaskAttribute root;

    public TaskData(TaskAttributeMapper mapper, String connectorKind, String repositoryUrl, String taskId) {
        Assert.isNotNull((Object)mapper);
        Assert.isNotNull((Object)connectorKind);
        Assert.isNotNull((Object)repositoryUrl);
        Assert.isNotNull((Object)taskId);
        this.mapper = mapper;
        this.connectorKind = connectorKind;
        this.repositoryUrl = repositoryUrl;
        this.taskId = taskId;
        this.root = new TaskAttribute(this);
    }

    public TaskAttribute getRoot() {
        return this.root;
    }

    public String getConnectorKind() {
        return this.connectorKind;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isNew() {
        return this.getTaskId().length() == 0;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public void setPartial(boolean partial) {
        this.partial = partial;
    }

    public TaskAttributeMapper getAttributeMapper() {
        return this.mapper;
    }
}

