/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger.messages;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.php.debug.core.debugger.messages.IDebugResponseMessage;
import org.eclipse.php.internal.debug.core.zend.communication.CommunicationUtilities;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.DebugMessageResponseImpl;

public class FileContentResponse
extends DebugMessageResponseImpl
implements IDebugResponseMessage {
    public static final int FAILURE = -1;
    public static final int SUCCESS = 0;
    public static final int FILES_IDENTICAL = 302;
    private byte[] content = null;

    @Override
    public int getType() {
        return 11001;
    }

    @Override
    public void serialize(DataOutputStream out) throws IOException {
        out.writeShort(this.getType());
        out.writeInt(this.getID());
        out.writeInt(this.getStatus());
        byte[] fileContent = this.getContent();
        int fileContentLength = 0;
        if (fileContent != null) {
            fileContentLength = fileContent.length;
        }
        out.writeInt(fileContentLength);
        if (fileContent != null) {
            out.write(fileContent);
        }
    }

    @Override
    public void deserialize(DataInputStream in) throws IOException {
        this.setID(in.readInt());
        this.setStatus(in.readInt());
        this.setContent(CommunicationUtilities.readStringAsBytes(in));
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getContentAsString() {
        return this.content.toString();
    }
}

