/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;

final class SingletonSortedSetDocValues
extends SortedSetDocValues {
    private final SortedDocValues in;
    private long ord;

    public SingletonSortedSetDocValues(SortedDocValues in) {
        if (in.docID() != -1) {
            throw new IllegalStateException("iterator has already been used: docID=" + in.docID());
        }
        this.in = in;
    }

    public SortedDocValues getSortedDocValues() {
        if (this.in.docID() != -1) {
            throw new IllegalStateException("iterator has already been used: docID=" + this.in.docID());
        }
        return this.in;
    }

    @Override
    public int docID() {
        return this.in.docID();
    }

    @Override
    public long nextOrd() {
        return this.ord;
    }

    @Override
    public int docValueCount() {
        return 1;
    }

    @Override
    public int nextDoc() throws IOException {
        int docID = this.in.nextDoc();
        if (docID != Integer.MAX_VALUE) {
            this.ord = this.in.ordValue();
        }
        return docID;
    }

    @Override
    public int advance(int target) throws IOException {
        int docID = this.in.advance(target);
        if (docID != Integer.MAX_VALUE) {
            this.ord = this.in.ordValue();
        }
        return docID;
    }

    @Override
    public boolean advanceExact(int target) throws IOException {
        if (this.in.advanceExact(target)) {
            this.ord = this.in.ordValue();
            return true;
        }
        return false;
    }

    @Override
    public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
        this.in.intoBitSet(upTo, bitSet, offset);
    }

    @Override
    public int docIDRunEnd() throws IOException {
        return this.in.docIDRunEnd();
    }

    @Override
    public BytesRef lookupOrd(long ord) throws IOException {
        return this.in.lookupOrd((int)ord);
    }

    @Override
    public long getValueCount() {
        return this.in.getValueCount();
    }

    @Override
    public long lookupTerm(BytesRef key) throws IOException {
        return this.in.lookupTerm(key);
    }

    @Override
    public TermsEnum termsEnum() throws IOException {
        return this.in.termsEnum();
    }

    @Override
    public long cost() {
        return this.in.cost();
    }
}

