/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.annotations;

import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.mylyn.internal.reviews.ui.annotations.Messages;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.spi.ModelUtil;
import org.eclipse.osgi.util.NLS;

public class CommentAnnotation
extends Annotation {
    public static final String COMMENT_ANNOTATION_ID = "org.eclipse.mylyn.reviews.ui.comment.Annotation";
    public static final String COMMENT_ANNOTATION_ME_ID = "org.eclipse.mylyn.reviews.ui.comment.AnnotationMe";
    private final Position position;
    private final IComment comment;

    public CommentAnnotation(int offset, int length, IComment comment) {
        super(comment.isMine() ? COMMENT_ANNOTATION_ME_ID : COMMENT_ANNOTATION_ID, false, null);
        this.position = new Position(offset, length);
        this.comment = comment;
    }

    public Position getPosition() {
        return this.position;
    }

    public String getText() {
        return NLS.bind((String)Messages.CommentAnnotation_X_dash_Y, (Object)this.comment.getAuthor().getDisplayName(), (Object)this.comment.getTitle());
    }

    public IComment getComment() {
        return this.comment;
    }

    public int hashCode() {
        int result = this.position == null ? 0 : this.position.hashCode();
        return ModelUtil.ecoreHash((int)result, (EObject)this.comment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CommentAnnotation other = (CommentAnnotation)((Object)obj);
        if (!Objects.equals(this.position, other.position)) {
            return false;
        }
        if (this.comment != null && other.comment != null && this.comment.getId() != null && other.comment.getId() != null) {
            return this.comment.getId().equals(other.comment.getId());
        }
        return EcoreUtil.equals((EObject)this.comment, (EObject)other.comment);
    }
}

