/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.typehierarchy;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.internal.ui.typehierarchy.HierarchyLabelProvider;
import org.eclipse.dltk.internal.ui.typehierarchy.HierarchyOpenAction;
import org.eclipse.dltk.internal.ui.typehierarchy.HierarchyViewerSorter;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyContentProvider;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.dltk.ui.viewsupport.DecoratingModelLabelProvider;
import org.eclipse.dltk.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public abstract class TypeHierarchyViewer
extends ProblemTreeViewer {
    private HierarchyOpenAction fOpen;
    private HierarchyLabelProvider fLabelProvider;

    public TypeHierarchyViewer(Composite parent, IContentProvider contentProvider, TypeHierarchyLifeCycle lifeCycle, IWorkbenchPart part, IPreferenceStore store) {
        super(new Tree(parent, 4));
        this.fLabelProvider = new HierarchyLabelProvider(lifeCycle, store);
        this.setLabelProvider((IBaseLabelProvider)new DecoratingModelLabelProvider(this.fLabelProvider, true));
        this.setUseHashlookup(true);
        this.setContentProvider(contentProvider);
        this.setSorter(new HierarchyViewerSorter(lifeCycle));
        this.fOpen = new HierarchyOpenAction((IWorkbenchSite)part.getSite());
        this.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                TypeHierarchyViewer.this.fOpen.run();
            }
        });
    }

    public void setQualifiedTypeName(boolean on) {
        if (on) {
            this.fLabelProvider.setTextFlags(this.fLabelProvider.getTextFlags() | 0x100000L);
        } else {
            this.fLabelProvider.setTextFlags(this.fLabelProvider.getTextFlags() & 0xFFFFFFFFFFEFFFFFL);
        }
        this.refresh();
    }

    public void initContextMenu(IMenuListener menuListener, String popupId, IWorkbenchPartSite viewSite) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(menuListener);
        Menu menu = menuMgr.createContextMenu((Control)this.getTree());
        this.getTree().setMenu(menu);
        viewSite.registerContextMenu(popupId, menuMgr, (ISelectionProvider)this);
    }

    public void contributeToContextMenu(IMenuManager menu) {
    }

    public void setMemberFilter(IMember[] memberFilter) {
        TypeHierarchyContentProvider contentProvider = this.getHierarchyContentProvider();
        if (contentProvider != null) {
            contentProvider.setMemberFilter(memberFilter);
        }
    }

    public boolean isMethodFiltering() {
        TypeHierarchyContentProvider contentProvider = this.getHierarchyContentProvider();
        if (contentProvider != null) {
            return contentProvider.getMemberFilter() != null;
        }
        return false;
    }

    public void setWorkingSetFilter(ViewerFilter filter) {
        this.fLabelProvider.setFilter(filter);
        TypeHierarchyContentProvider contentProvider = this.getHierarchyContentProvider();
        if (contentProvider != null) {
            contentProvider.setWorkingSetFilter(filter);
        }
    }

    public Object containsElements() {
        Object[] elements;
        TypeHierarchyContentProvider contentProvider = this.getHierarchyContentProvider();
        if (contentProvider != null && (elements = contentProvider.getElements(null)).length > 0) {
            return elements[0];
        }
        return null;
    }

    public IType getTreeRootType() {
        Object[] elements;
        TypeHierarchyContentProvider contentProvider = this.getHierarchyContentProvider();
        if (contentProvider != null && (elements = contentProvider.getElements(null)).length > 0 && elements[0] instanceof IType) {
            return (IType)elements[0];
        }
        return null;
    }

    public boolean isElementShown(Object element) {
        return this.findItem(element) != null;
    }

    public abstract void updateContent(boolean var1);

    public abstract String getTitle();

    public void setContentProvider(IContentProvider cp) {
        Assert.isTrue((boolean)(cp instanceof TypeHierarchyContentProvider));
        super.setContentProvider(cp);
    }

    protected TypeHierarchyContentProvider getHierarchyContentProvider() {
        return (TypeHierarchyContentProvider)this.getContentProvider();
    }
}

