/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.sphinx.emf.validation.bridge.extensions.RulesExtCache;
import org.eclipse.sphinx.emf.validation.listeners.ResourceURIChangeListener;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.sphinx.emf.validation";
    private static Activator plugin;
    private static IResourceChangeListener resourceChangeListener;

    static {
        resourceChangeListener = null;
    }

    public Activator() {
        resourceChangeListener = new ResourceURIChangeListener();
    }

    public void start(BundleContext context) throws Exception {
        try {
            super.start(context);
            plugin = this;
            RulesExtCache.getSingleton().startup();
        }
        catch (Exception e) {
            PlatformLogUtil.logAsError((Plugin)plugin, (Object)e);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(resourceChangeListener, 17);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        RulesExtCache.getSingleton().shutdown();
        super.stop(context);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspace.removeResourceChangeListener(resourceChangeListener);
        }
    }

    public static Activator getDefault() {
        return plugin;
    }
}

