/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.SessionEventBroker;
import org.eclipse.sirius.ext.base.Option;

public class SessionEventBrokerImpl
extends ResourceSetListenerImpl
implements SessionEventBroker {
    private static Function<ModelChangeTrigger, Integer> getPriorityFunction = new Function<ModelChangeTrigger, Integer>(){

        public Integer apply(ModelChangeTrigger from) {
            return from.priority();
        }
    };
    private TransactionalEditingDomain domain;
    private Multimap<EObject, ModelChangeTrigger> eObjectsToListeners = HashMultimap.create();
    private Map<EStructuralFeature, Multimap<EObject, ModelChangeTrigger>> featuresToListeners = new HashMap<EStructuralFeature, Multimap<EObject, ModelChangeTrigger>>();
    private Multimap<NotificationFilter, ModelChangeTrigger> scopedTriggers = HashMultimap.create();

    public SessionEventBrokerImpl(TransactionalEditingDomain domain) {
        super(NotificationFilter.NOT_TOUCH);
        this.domain = domain;
        domain.addResourceSetListener((ResourceSetListener)this);
    }

    public static NotificationFilter asFilter(final Predicate<Notification> pred) {
        return new NotificationFilter.Custom(){

            public boolean matches(Notification notification) {
                return pred.apply((Object)notification);
            }
        };
    }

    @Override
    public void addLocalTrigger(EObject element, EStructuralFeature feature, ModelChangeTrigger trigger) {
        HashMultimap listeners = this.featuresToListeners.get(feature);
        if (listeners == null) {
            listeners = HashMultimap.create();
            this.featuresToListeners.put(feature, (Multimap<EObject, ModelChangeTrigger>)listeners);
        }
        listeners.put((Object)element, (Object)trigger);
    }

    @Override
    public void addLocalTrigger(EObject element, ModelChangeTrigger trigger) {
        this.eObjectsToListeners.put((Object)element, (Object)trigger);
    }

    private void collectListeners(Notification msg, EObject changedObj, Multimap<EObject, ModelChangeTrigger> map, Multimap<ModelChangeTrigger, Notification> result) {
        Collection listeners = map.get((Object)changedObj);
        if (listeners != null) {
            for (ModelChangeTrigger preCommitListener : listeners) {
                result.put((Object)preCommitListener, (Object)msg);
            }
        }
    }

    private void collectScopedListeners(final Notification msg, Multimap<ModelChangeTrigger, Notification> result) {
        Iterable filteredScoped = Iterables.filter((Iterable)this.scopedTriggers.keys(), (Predicate)new Predicate<NotificationFilter>(){

            public boolean apply(NotificationFilter input) {
                return input.matches(msg);
            }
        });
        for (NotificationFilter predicate : filteredScoped) {
            Collection triggersValidForThisNotification = this.scopedTriggers.get((Object)predicate);
            if (triggersValidForThisNotification == null) continue;
            for (ModelChangeTrigger modelChangeTrigger : triggersValidForThisNotification) {
                result.put((Object)modelChangeTrigger, (Object)msg);
            }
        }
    }

    @Override
    public void addLocalTrigger(NotificationFilter scope, ModelChangeTrigger trigger) {
        if (!this.scopedTriggers.containsEntry((Object)scope, (Object)trigger)) {
            this.scopedTriggers.put((Object)scope, (Object)trigger);
        }
    }

    private Multimap<ModelChangeTrigger, Notification> collectListenersToNotify(List<Notification> notifications) {
        HashMultimap result = HashMultimap.create();
        for (Notification msg : notifications) {
            Multimap<EObject, ModelChangeTrigger> eObhectsToListenersMap;
            this.collectScopedListeners(msg, (Multimap<ModelChangeTrigger, Notification>)result);
            if (!(msg.getNotifier() instanceof EObject)) continue;
            EObject changedObj = (EObject)msg.getNotifier();
            this.collectListeners(msg, changedObj, this.eObjectsToListeners, (Multimap<ModelChangeTrigger, Notification>)result);
            if (!(msg.getFeature() instanceof EStructuralFeature) || (eObhectsToListenersMap = this.featuresToListeners.get(msg.getFeature())) == null) continue;
            this.collectListeners(msg, changedObj, eObhectsToListenersMap, (Multimap<ModelChangeTrigger, Notification>)result);
        }
        return result;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    private void removeListenerFromMap(ModelChangeTrigger listenerToRemove, Multimap<?, ModelChangeTrigger> map) {
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            ModelChangeTrigger cur = (ModelChangeTrigger)it.next();
            if (cur != listenerToRemove) continue;
            it.remove();
        }
    }

    @Override
    public void removeLocalTrigger(ModelChangeTrigger listenerToRemove) {
        this.removeListenerFromMap(listenerToRemove, this.eObjectsToListeners);
        for (Multimap<EObject, ModelChangeTrigger> map : this.featuresToListeners.values()) {
            this.removeListenerFromMap(listenerToRemove, map);
        }
        this.removeListenerFromMap(listenerToRemove, this.scopedTriggers);
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        CompoundCommand compoundCommand = new CompoundCommand();
        Multimap<ModelChangeTrigger, Notification> listenersToNotify = this.collectListenersToNotify(event.getNotifications());
        if (listenersToNotify != null && !listenersToNotify.isEmpty()) {
            Ordering priorityOrdering = Ordering.natural().onResultOf(getPriorityFunction);
            List sortedKeys = priorityOrdering.sortedCopy((Iterable)listenersToNotify.keySet());
            for (ModelChangeTrigger key : sortedKeys) {
                Option<Command> triggerCmdOption;
                Collection notif = listenersToNotify.get((Object)key);
                if (notif == null || notif.isEmpty() || !(triggerCmdOption = key.localChangesAboutToCommit(notif)).some() || !((Command)triggerCmdOption.get()).canExecute()) continue;
                compoundCommand.append((Command)triggerCmdOption.get());
            }
        }
        return compoundCommand;
    }

    @Override
    public void dispose() {
        this.domain.removeResourceSetListener((ResourceSetListener)this);
        this.eObjectsToListeners.clear();
        this.featuresToListeners.clear();
        this.scopedTriggers.clear();
    }
}

