/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.content.ContentSourceCompletableFuture;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.CharsetStringBuilder;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.UrlEncoded;

public class FormFields
extends ContentSourceCompletableFuture<Fields> {
    public static final String MAX_FIELDS_ATTRIBUTE = "org.eclipse.jetty.server.Request.maxFormKeys";
    public static final String MAX_LENGTH_ATTRIBUTE = "org.eclipse.jetty.server.Request.maxFormContentSize";
    private static final CompletableFuture<Fields> EMPTY = CompletableFuture.completedFuture(Fields.EMPTY);
    private final Fields _fields;
    private final CharsetStringBuilder _builder;
    private final int _maxFields;
    private final int _maxLength;
    private int _length;
    private String _name;
    private int _percent = 0;
    private byte _percentCode;

    public static Charset getFormEncodedCharset(Request request) {
        HttpConfiguration config = request.getConnectionMetaData().getHttpConfiguration();
        if (!config.getFormEncodedMethods().contains(request.getMethod())) {
            return null;
        }
        String contentType = request.getHeaders().get(HttpHeader.CONTENT_TYPE);
        if (request.getLength() == 0L || StringUtil.isBlank((String)contentType)) {
            return null;
        }
        MimeTypes.Type type = (MimeTypes.Type)MimeTypes.CACHE.get(MimeTypes.getContentTypeWithoutCharset((String)contentType));
        if (MimeTypes.Type.FORM_ENCODED != type) {
            return null;
        }
        String cs = MimeTypes.getCharsetFromContentType((String)contentType);
        return StringUtil.isEmpty((String)cs) ? StandardCharsets.UTF_8 : Charset.forName(cs);
    }

    public static void set(Request request, CompletableFuture<Fields> fields) {
        request.setAttribute(FormFields.class.getName(), fields);
    }

    public static CompletableFuture<Fields> get(Request request) {
        Object attr = request.getAttribute(FormFields.class.getName());
        if (attr instanceof FormFields) {
            FormFields futureFormFields = (FormFields)((Object)attr);
            return futureFormFields;
        }
        return EMPTY;
    }

    public static CompletableFuture<Fields> from(Request request) {
        int maxFields = FormFields.getRequestAttribute(request, MAX_FIELDS_ATTRIBUTE);
        int maxLength = FormFields.getRequestAttribute(request, MAX_LENGTH_ATTRIBUTE);
        return FormFields.from(request, maxFields, maxLength);
    }

    public static CompletableFuture<Fields> from(Request request, Charset charset) {
        int maxFields = FormFields.getRequestAttribute(request, MAX_FIELDS_ATTRIBUTE);
        int maxLength = FormFields.getRequestAttribute(request, MAX_LENGTH_ATTRIBUTE);
        return FormFields.from(request, charset, maxFields, maxLength);
    }

    public static CompletableFuture<Fields> from(Request request, int maxFields, int maxLength) {
        return FormFields.from(request, FormFields.getFormEncodedCharset(request), maxFields, maxLength);
    }

    public static CompletableFuture<Fields> from(Request request, Charset charset, int maxFields, int maxLength) {
        return FormFields.from(request, request, charset, maxFields, maxLength);
    }

    static CompletableFuture<Fields> from(Content.Source source, Attributes attributes, Charset charset, int maxFields, int maxLength) {
        Object attr = attributes.getAttribute(FormFields.class.getName());
        if (attr instanceof FormFields) {
            FormFields futureFormFields = (FormFields)((Object)attr);
            return futureFormFields;
        }
        if (attr instanceof Fields) {
            Fields fields = (Fields)attr;
            return CompletableFuture.completedFuture(fields);
        }
        if (charset == null) {
            return EMPTY;
        }
        FormFields futureFormFields = new FormFields(source, charset, maxFields, maxLength);
        attributes.setAttribute(FormFields.class.getName(), (Object)futureFormFields);
        futureFormFields.parse();
        return futureFormFields;
    }

    private static int getRequestAttribute(Request request, String attribute) {
        Object value = request.getAttribute(attribute);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException x) {
            return -1;
        }
    }

    private FormFields(Content.Source source, Charset charset, int maxFields, int maxSize) {
        super(source);
        this._maxFields = maxFields;
        this._maxLength = maxSize;
        this._builder = CharsetStringBuilder.forCharset((Charset)charset);
        this._fields = new Fields();
    }

    protected Fields parse(Content.Chunk chunk) throws CharacterCodingException {
        String value = null;
        ByteBuffer buffer = chunk.getByteBuffer();
        block14: while (true) {
            block21: {
                if (!BufferUtil.hasContent((ByteBuffer)buffer)) break block21;
                byte b = buffer.get();
                switch (this._percent) {
                    case 1: {
                        this._percentCode = b;
                        ++this._percent;
                        continue block14;
                    }
                    case 2: {
                        this._builder.append(UrlEncoded.decodeHexByte((char)((char)this._percentCode), (char)((char)b)));
                        this._percent = 0;
                        continue block14;
                    }
                }
                if (this._name == null) {
                    switch (b) {
                        case 61: {
                            this._name = this._builder.build();
                            this.checkLength(this._name);
                            continue block14;
                        }
                        case 43: {
                            this._builder.append((byte)32);
                            continue block14;
                        }
                        case 37: {
                            ++this._percent;
                            continue block14;
                        }
                    }
                    this._builder.append(b);
                    continue;
                }
                switch (b) {
                    case 38: {
                        value = this._builder.build();
                        this.checkLength(value);
                        break block21;
                    }
                    case 43: {
                        this._builder.append((byte)32);
                        break;
                    }
                    case 37: {
                        ++this._percent;
                        break;
                    }
                    default: {
                        this._builder.append(b);
                    }
                }
                continue;
            }
            if (this._name != null) {
                if (value == null && chunk.isLast()) {
                    if (this._percent > 0) {
                        this._builder.append((byte)37);
                        this._builder.append(this._percentCode);
                    }
                    value = this._builder.build();
                    this.checkLength(value);
                }
                if (value != null) {
                    Fields.Field field = new Fields.Field(this._name, value);
                    this._name = null;
                    value = null;
                    if (this._maxFields >= 0 && this._fields.getSize() >= this._maxFields) {
                        throw new IllegalStateException("form with too many fields > " + this._maxFields);
                    }
                    this._fields.add(field);
                }
            }
            if (!BufferUtil.hasContent((ByteBuffer)buffer)) break;
        }
        return chunk.isLast() ? this._fields : null;
    }

    private void checkLength(String nameOrValue) {
        if (this._maxLength >= 0) {
            this._length += nameOrValue.length();
            if (this._length > this._maxLength) {
                throw new IllegalStateException("form too large");
            }
        }
    }
}

