/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.internal.tab;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.rap.tools.launch.internal.LaunchMessages;
import org.eclipse.rap.tools.launch.internal.RAPLaunchConfig;
import org.eclipse.rap.tools.launch.internal.RAPLaunchConfigValidator;
import org.eclipse.rap.tools.launch.internal.URLBuilder;
import org.eclipse.rap.tools.launch.internal.tab.DataLocationBlock;
import org.eclipse.rap.tools.launch.internal.util.ErrorUtil;
import org.eclipse.rap.tools.launch.internal.util.Images;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public final class MainTab
extends AbstractLauncherTab {
    private static final String BROWSER_PREFERENCE_PAGE = "org.eclipse.ui.browser.preferencePage";
    private final GridDataFactory fillHorizontal;
    private final ModifyListener modifyListener;
    private final SelectionListener selectionListener;
    private final Image tabImage = Images.DESC_MAIN_TAB.createImage();
    private final Image warnImage = Images.WARNING.createImage();
    private Text servletPathTextField;
    private Button openBrowserCheckBox;
    private Button internalBrowserRadioButton;
    private Button externalBrowserRadioButton;
    private Text applicationUrlTextField;
    private Button useFixedPortCheckBox;
    private Button contextPathCheckBox;
    private Text contextPathTextField;
    private Spinner portSpinner;
    private Button useSessionTimeoutCheckBox;
    private Spinner sessionTimeoutSpinner;
    private Button developmentModeCheckBox;
    private ILaunchConfigurationListener launchConfigListener;
    private DataLocationBlock dataLocationBlock;

    public MainTab() {
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.fillHorizontal = GridDataFactory.createFrom((GridData)gridData);
        this.modifyListener = this.createDialogModifyListener();
        this.selectionListener = this.createDialogSelectionListener();
        this.addLaunchConfigListener();
    }

    private ModifyListener createDialogModifyListener() {
        ModifyListener result = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        };
        return result;
    }

    private SelectionAdapter createDialogSelectionListener() {
        SelectionAdapter result = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        };
        return result;
    }

    public void dispose() {
        this.tabImage.dispose();
        this.warnImage.dispose();
        ILaunchManager launchManager = this.getLaunchManager();
        launchManager.removeLaunchConfigurationListener(this.launchConfigListener);
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.createBrowserModeSection(container);
        this.createRuntimeSettingsSection(container);
        this.createRAPSettingsSection(container);
        this.createDataLocationSection(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    public String getName() {
        return LaunchMessages.MainTab_Name;
    }

    public Image getImage() {
        return this.tabImage;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        RAPLaunchConfig rapConfig = new RAPLaunchConfig(config);
        try {
            this.servletPathTextField.setText(rapConfig.getServletPath());
            this.useFixedPortCheckBox.setSelection(rapConfig.getUseManualPort());
            this.portSpinner.setSelection(rapConfig.getPort());
            this.contextPathCheckBox.setSelection(rapConfig.getUseManualContextPath());
            this.contextPathTextField.setText(rapConfig.getContextPath());
            boolean openBrowser = rapConfig.getOpenBrowser();
            this.openBrowserCheckBox.setSelection(openBrowser);
            this.internalBrowserRadioButton.setEnabled(openBrowser);
            this.externalBrowserRadioButton.setEnabled(openBrowser);
            if (RAPLaunchConfig.BrowserMode.EXTERNAL.equals(rapConfig.getBrowserMode())) {
                this.externalBrowserRadioButton.setSelection(true);
                this.internalBrowserRadioButton.setSelection(false);
            } else {
                this.externalBrowserRadioButton.setSelection(false);
                this.internalBrowserRadioButton.setSelection(true);
            }
            this.useSessionTimeoutCheckBox.setSelection(rapConfig.getUseSessionTimeout());
            this.sessionTimeoutSpinner.setSelection(rapConfig.getSessionTimeout());
            this.developmentModeCheckBox.setSelection(rapConfig.getDevelopmentMode());
            this.dataLocationBlock.initializeFrom(rapConfig);
        }
        catch (CoreException e) {
            ErrorUtil.show(null, e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        RAPLaunchConfig rapConfig = new RAPLaunchConfig((ILaunchConfiguration)config);
        rapConfig.setServletPath(this.servletPathTextField.getText());
        rapConfig.setOpenBrowser(this.openBrowserCheckBox.getSelection());
        rapConfig.setBrowserMode(this.getBrowserMode());
        this.portSpinner.setEnabled(this.useFixedPortCheckBox.getSelection());
        rapConfig.setUseManualPort(this.useFixedPortCheckBox.getSelection());
        rapConfig.setPort(this.portSpinner.getSelection());
        this.contextPathTextField.setEnabled(this.contextPathCheckBox.getSelection());
        rapConfig.setUseManualContextPath(this.contextPathCheckBox.getSelection());
        rapConfig.setContextPath(this.contextPathTextField.getText());
        this.sessionTimeoutSpinner.setEnabled(this.useSessionTimeoutCheckBox.getSelection());
        rapConfig.setUseSessionTimeout(this.useSessionTimeoutCheckBox.getSelection());
        rapConfig.setSessionTimeout(this.sessionTimeoutSpinner.getSelection());
        rapConfig.setDevelopmentMode(this.developmentModeCheckBox.getSelection());
        rapConfig.setDataLocation(this.dataLocationBlock.getLocation());
        boolean useDefaultDataLocation = this.dataLocationBlock.getUseDefaultDataLocation();
        rapConfig.setUseDefaultDataLocation(useDefaultDataLocation);
        rapConfig.setDoClearDataLocation(this.dataLocationBlock.getDoClearDataLocation());
        rapConfig.setAskClearDataLocation(false);
        this.validate(rapConfig);
        this.setDirty(true);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        RAPLaunchConfig.setDefaults(config);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.getErrorMessage() == null;
    }

    public void validateTab() {
    }

    private void addLaunchConfigListener() {
        this.launchConfigListener = this.getLaunchConfigListener();
        ILaunchManager launchManager = this.getLaunchManager();
        launchManager.addLaunchConfigurationListener(this.launchConfigListener);
    }

    private ILaunchConfigurationListener getLaunchConfigListener() {
        ILaunchConfigurationListener result = new ILaunchConfigurationListener(){

            public void launchConfigurationChanged(ILaunchConfiguration configuration) {
                RAPLaunchConfig rapConfig = new RAPLaunchConfig(configuration);
                MainTab.this.validate(rapConfig);
                MainTab.this.updateApplicationUrl(rapConfig);
            }

            public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            }

            public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
            }
        };
        return result;
    }

    private void createDataLocationSection(Composite container) {
        this.dataLocationBlock = new DataLocationBlock(this);
        Control blockControl = this.dataLocationBlock.createControl(container);
        blockControl.setLayoutData((Object)new GridData(768));
    }

    private void createBrowserModeSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)this.fillHorizontal.create());
        group.setText(LaunchMessages.MainTab_Browser);
        group.setLayout((Layout)new GridLayout());
        this.createBrowserActivationPart((Composite)group);
        this.createServletPathPart((Composite)group);
    }

    private void createBrowserActivationPart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)this.fillHorizontal.span(2, 1).create());
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.openBrowserCheckBox = new Button(composite, 32);
        this.openBrowserCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.openBrowserCheckBox.setText(LaunchMessages.MainTab_OpenApplicationIn);
        Link browserPrefsLink = this.createBrowserPrefsLink(composite);
        browserPrefsLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Composite modePart = this.createBrowserModePart(composite);
        modePart.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).indent(17, 0).create());
        this.addSelectionListeners();
    }

    private Link createBrowserPrefsLink(Composite composite) {
        Link link = new Link(composite, 0);
        link.setText(LaunchMessages.MainTab_ConfigureBrowsers);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainTab.this.openBrowserPrefs();
            }
        });
        return link;
    }

    private Composite createBrowserModePart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(256));
        this.internalBrowserRadioButton = new Button(composite, 16);
        this.internalBrowserRadioButton.setText(LaunchMessages.MainTab_InternalBrowser);
        this.internalBrowserRadioButton.addSelectionListener(this.selectionListener);
        this.externalBrowserRadioButton = new Button(composite, 16);
        this.externalBrowserRadioButton.setText(LaunchMessages.MainTab_ExternalBrowser);
        this.externalBrowserRadioButton.addSelectionListener(this.selectionListener);
        return composite;
    }

    private void addSelectionListeners() {
        this.openBrowserCheckBox.addSelectionListener(this.selectionListener);
        this.openBrowserCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean openBrowser = MainTab.this.openBrowserCheckBox.getSelection();
                MainTab.this.internalBrowserRadioButton.setEnabled(openBrowser);
                MainTab.this.externalBrowserRadioButton.setEnabled(openBrowser);
                MainTab.this.servletPathTextField.setEnabled(openBrowser);
            }
        });
    }

    private void createServletPathPart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)this.fillHorizontal.create());
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblServletPath = new Label(composite, 0);
        lblServletPath.setText(LaunchMessages.MainTab_ServletPath);
        this.servletPathTextField = new Text(composite, 2048);
        this.servletPathTextField.addModifyListener(this.modifyListener);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.servletPathTextField);
        Label finalUrlLabel = new Label(composite, 0);
        finalUrlLabel.setText(LaunchMessages.MainTab_ApplicationUrl);
        this.applicationUrlTextField = new Text(composite, 12);
        this.applicationUrlTextField.setBackground(this.applicationUrlTextField.getParent().getBackground());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.applicationUrlTextField);
    }

    private void createRuntimeSettingsSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)this.fillHorizontal.create());
        group.setText(LaunchMessages.MainTab_ServerSettings);
        group.setLayout((Layout)new GridLayout(4, false));
        this.useFixedPortCheckBox = new Button((Composite)group, 32);
        this.useFixedPortCheckBox.setText(LaunchMessages.MainTab_ManualPortConfig);
        this.useFixedPortCheckBox.addSelectionListener(this.selectionListener);
        this.portSpinner = new Spinner((Composite)group, 2048);
        this.portSpinner.setLayoutData((Object)new GridData(4, -1, true, false));
        this.portSpinner.setMinimum(0);
        this.portSpinner.setMaximum(65535);
        this.portSpinner.addModifyListener(this.modifyListener);
        this.useSessionTimeoutCheckBox = new Button((Composite)group, 32);
        GridDataFactory.fillDefaults().indent(25, 0).applyTo((Control)this.useSessionTimeoutCheckBox);
        this.useSessionTimeoutCheckBox.setText(LaunchMessages.MainTab_ManualTimeoutConfig);
        this.useSessionTimeoutCheckBox.addSelectionListener(this.selectionListener);
        this.sessionTimeoutSpinner = new Spinner((Composite)group, 2048);
        this.sessionTimeoutSpinner.setLayoutData((Object)new GridData(4, -1, true, false));
        this.sessionTimeoutSpinner.setMinimum(0);
        this.sessionTimeoutSpinner.setMaximum(Integer.MAX_VALUE);
        this.sessionTimeoutSpinner.addModifyListener(this.modifyListener);
        this.contextPathCheckBox = new Button((Composite)group, 32);
        this.contextPathCheckBox.setText(LaunchMessages.MainTab_ManualContextPath);
        this.contextPathCheckBox.addSelectionListener(this.selectionListener);
        this.contextPathTextField = new Text((Composite)group, 2052);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.contextPathTextField);
        this.contextPathTextField.addModifyListener(this.modifyListener);
    }

    private void createRAPSettingsSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)this.fillHorizontal.create());
        group.setText(LaunchMessages.MainTab_RAPSettings);
        group.setLayout((Layout)new GridLayout(2, true));
        Composite leftPart = new Composite((Composite)group, 0);
        leftPart.setLayout((Layout)this.createGridLayoutWithoutMargin(1));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)leftPart);
        this.createRAPSettingsLeftPart(leftPart);
        Composite rightPart = new Composite((Composite)group, 0);
        rightPart.setLayout((Layout)this.createGridLayoutWithoutMargin(2));
        GridDataFactory.fillDefaults().grab(true, false).indent(15, 0).applyTo((Control)rightPart);
    }

    private GridLayout createGridLayoutWithoutMargin(int numColumns) {
        GridLayout result = new GridLayout(numColumns, false);
        result.marginHeight = 0;
        result.marginWidth = 0;
        return result;
    }

    private void createRAPSettingsLeftPart(Composite leftPartComposite) {
        this.developmentModeCheckBox = new Button(leftPartComposite, 32);
        this.developmentModeCheckBox.setText(LaunchMessages.MainTab_DevelopmentMode);
        this.developmentModeCheckBox.addSelectionListener(this.selectionListener);
    }

    private void validate(RAPLaunchConfig config) {
        RAPLaunchConfigValidator validator = new RAPLaunchConfigValidator(config);
        IStatus[] states = validator.validate();
        String infoMessage = MainTab.findMessage(states, 1);
        String warnMessage = MainTab.findMessage(states, 2);
        String errorMessage = MainTab.findMessage(states, 4);
        if (warnMessage != null) {
            this.setMessage(warnMessage);
        } else {
            this.setMessage(infoMessage);
        }
        this.setErrorMessage(errorMessage);
    }

    private void updateApplicationUrl(RAPLaunchConfig config) {
        String applicationUrl;
        try {
            applicationUrl = this.getApplicationUrl(config);
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            applicationUrl = "";
        }
        this.udpateApplicationUrlTextField(applicationUrl);
    }

    private String getApplicationUrl(RAPLaunchConfig config) throws CoreException {
        String result;
        if (config.getUseManualPort()) {
            int port = config.getPort();
            result = URLBuilder.fromLaunchConfig(config, port, false);
        } else {
            result = URLBuilder.fromLaunchConfig(config, "<PORT>", false);
        }
        return result;
    }

    private void udpateApplicationUrlTextField(final String finalApplicationUrl) {
        if (this.applicationUrlTextField != null && !this.applicationUrlTextField.isDisposed()) {
            this.applicationUrlTextField.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!finalApplicationUrl.equals(MainTab.this.applicationUrlTextField.getText())) {
                        MainTab.this.applicationUrlTextField.setText(finalApplicationUrl);
                    }
                }
            });
        }
    }

    private static String findMessage(IStatus[] states, int severity) {
        String result = null;
        int i = 0;
        while (result == null && i < states.length) {
            if (states[i].matches(severity)) {
                result = states[i].getMessage();
            }
            ++i;
        }
        return result;
    }

    private void openBrowserPrefs() {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)BROWSER_PREFERENCE_PAGE, null, null);
        dialog.open();
        dialog.close();
    }

    private RAPLaunchConfig.BrowserMode getBrowserMode() {
        boolean selection = this.externalBrowserRadioButton.getSelection();
        return selection ? RAPLaunchConfig.BrowserMode.EXTERNAL : RAPLaunchConfig.BrowserMode.INTERNAL;
    }
}

