/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.rwt.internal.shortcut;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IType;
import org.eclipse.rap.tools.launch.rwt.internal.config.RWTLaunchConfig;

public class LaunchConfigCreator {
    static ILaunchConfiguration create(IType type, RWTLaunchConfig.LaunchTarget launchTarget, String servletPath) throws CoreException {
        ILaunchConfigurationType configType = RWTLaunchConfig.getType();
        String name = LaunchConfigCreator.launchConfigNameFromType(type);
        ILaunchConfigurationWorkingCopy launchConfig = configType.newInstance(null, name);
        launchConfig.setMappedResources(new IResource[]{type.getUnderlyingResource()});
        RWTLaunchConfig.setDefaults(launchConfig);
        RWTLaunchConfig rwtLaunchConfig = new RWTLaunchConfig((ILaunchConfiguration)launchConfig);
        rwtLaunchConfig.setProjectName(LaunchConfigCreator.getProjectName(type));
        rwtLaunchConfig.setLaunchTarget(launchTarget);
        if (RWTLaunchConfig.LaunchTarget.ENTRY_POINT.equals((Object)launchTarget)) {
            rwtLaunchConfig.setEntryPoint(type.getFullyQualifiedName());
        } else {
            rwtLaunchConfig.setAppConfig(type.getFullyQualifiedName());
        }
        if (servletPath != null) {
            rwtLaunchConfig.setServletPath(servletPath);
        }
        return launchConfig.doSave();
    }

    private static String launchConfigNameFromType(IType type) {
        String qualifiedName = type.getTypeQualifiedName('.');
        return LaunchConfigCreator.getLaunchManager().generateLaunchConfigurationName(qualifiedName);
    }

    private static String getProjectName(IType type) {
        return type.getJavaProject().getElementName();
    }

    private static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private LaunchConfigCreator() {
    }
}

