/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.apache.jxpath.util;

import java.util.HashMap;
import org.eclipse.rap.e4.apache.jxpath.util.BasicTypeConverter;
import org.eclipse.rap.e4.apache.jxpath.util.TypeConverter;

public class TypeUtils {
    private static TypeConverter typeConverter = new BasicTypeConverter();
    private static final HashMap PRIMITIVE_TYPE_MAP = new HashMap(){
        {
            this.put(Integer.TYPE, Integer.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Short.TYPE, Short.class);
            this.put(Character.TYPE, Character.class);
            this.put(Long.TYPE, Long.class);
            this.put(Float.TYPE, Float.class);
            this.put(Double.TYPE, Double.class);
            this.put(Boolean.TYPE, Boolean.class);
        }
    };

    public static synchronized void setTypeConverter(TypeConverter converter) {
        typeConverter = converter;
    }

    public static TypeConverter getTypeConverter() {
        return typeConverter;
    }

    public static boolean canConvert(Object object, Class toType) {
        return typeConverter.canConvert(object, toType);
    }

    public static Object convert(Object object, Class toType) {
        return typeConverter.convert(object, toType);
    }

    public static Class wrapPrimitive(Class p) {
        return p.isPrimitive() ? (Class)PRIMITIVE_TYPE_MAP.get(p) : p;
    }
}

