/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ComboTab
extends ExampleTab {
    private static final String PROP_SELECTION_LISTENER = "selectionListener";
    private static final String PROP_MODIFY_LISTENER = "modifyListener";
    private static final String[] ITEMS = new String[]{"Eiffel", "Java", "Python", "Ruby", "Simula", "Smalltalk"};
    private Combo firstCombo;
    private Combo verifyCombo;
    private Combo viewerCombo;
    private CCombo cCombo;
    private Button createEmptyComboButton;
    private Button preselectFirstItemButton;
    private Button editableButton;
    private boolean empty;
    private boolean preselectItem;

    public ComboTab() {
        super("Combo");
    }

    @Override
    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("READ_ONLY", 8);
        this.createStyleButton("FLAT", 0x800000);
        this.createOrientationButton();
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createFontChooser();
        this.createCursorCombo();
        this.createPropertyCheckbox("Add Selection Listener", PROP_SELECTION_LISTENER);
        this.createPropertyCheckbox("Add Modify Listener", PROP_MODIFY_LISTENER);
        Group grpManioulateCCombo = new Group(parent, 0);
        grpManioulateCCombo.setText("Manipulate CCombo");
        grpManioulateCCombo.setLayout((Layout)new GridLayout());
        this.createSetTextLimitButton((Composite)grpManioulateCCombo, false);
        this.createChangeSizeButton((Composite)grpManioulateCCombo);
        this.createToggleListVisibilityButton((Composite)grpManioulateCCombo);
        this.createEditableButton((Composite)grpManioulateCCombo);
        this.createTextButton((Composite)grpManioulateCCombo);
        Group group = new Group(parent, 0);
        group.setText("Manipulate First Combo");
        group.setLayout((Layout)new GridLayout());
        this.createAddButton((Composite)group);
        this.createSetVisibleItemCountButton((Composite)group);
        this.createRemoveAllButton((Composite)group);
        this.createDeselectAllButton((Composite)group);
        this.createRemoveFirstItemButton((Composite)group);
        this.createSelectFirstItemButton((Composite)group);
        this.createEmptyComboButton = new Button((Composite)group, 32);
        this.createEmptyComboButton.setText("Create Empty Combo");
        this.createEmptyComboButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComboTab.this.createEmptyComboButton.getSelection()) {
                    ComboTab.this.empty = true;
                } else {
                    ComboTab.this.empty = false;
                }
                ComboTab.this.createNew();
            }
        });
        this.preselectFirstItemButton = new Button((Composite)group, 32);
        this.preselectFirstItemButton.setText("Preselect First Item");
        this.preselectFirstItemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComboTab.this.preselectFirstItemButton.getSelection()) {
                    ComboTab.this.preselectItem = true;
                } else {
                    ComboTab.this.preselectItem = false;
                }
                ComboTab.this.createNew();
            }
        });
        Label selectionTitle = new Label((Composite)group, 0);
        selectionTitle.setText("Text selection:");
        this.createSetSelectionControls((Composite)group);
        this.createGetSelectionControls((Composite)group);
        this.createSetTextLimitButton((Composite)group, true);
    }

    @Override
    protected void createExampleControls(final Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        int style = this.getStyle();
        Label lblFilledCombo = new Label(parent, 0);
        lblFilledCombo.setText("Filled Combo");
        this.firstCombo = new Combo(parent, style);
        if (!this.empty) {
            this.firstCombo.setItems(ITEMS);
        }
        if (!this.empty && this.preselectItem) {
            this.firstCombo.select(0);
        }
        if (this.hasCreateProperty(PROP_SELECTION_LISTENER)) {
            this.firstCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    this.show(event, false);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.show(event, true);
                }

                private void show(SelectionEvent event, boolean defaultSelection) {
                    String type = defaultSelection ? "DefaultSelection" : "Selection";
                    String msg = String.valueOf(type) + ": " + event + "\n" + "Text: " + ComboTab.this.firstCombo.getText() + "\n" + "Selection: " + ComboTab.this.firstCombo.getSelectionIndex();
                    ComboTab.this.log(msg);
                }
            });
        }
        if (this.hasCreateProperty(PROP_MODIFY_LISTENER)) {
            this.firstCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    ComboTab.this.log(event.toString());
                }
            });
        }
        Button btnShowSelection = new Button(parent, 8);
        btnShowSelection.setText("Show Selection");
        btnShowSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ComboTab.this.showSelection(ComboTab.this.firstCombo.getItems(), ComboTab.this.firstCombo.getSelectionIndex());
            }
        });
        Label lblVerifyCombo = new Label(parent, 0);
        lblVerifyCombo.setText("Combo with VerifyListener (only 0-9 allowed)");
        this.verifyCombo = new Combo(parent, style);
        this.verifyCombo.setLayoutData((Object)this.createGridDataWithSpan(0, 2));
        this.verifyCombo.add("0");
        this.verifyCombo.add("1");
        this.verifyCombo.add("2");
        this.verifyCombo.add("3");
        this.verifyCombo.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                StringBuffer allowedText = new StringBuffer();
                int i = 0;
                while (i < event.text.length()) {
                    char ch = event.text.charAt(i);
                    if (ch >= '0' && ch <= '9') {
                        allowedText.append(ch);
                    }
                    ++i;
                }
                event.text = allowedText.toString();
            }
        });
        Label lblViewerCombo = new Label(parent, 0);
        String msg = "ComboViewer with context menu";
        lblViewerCombo.setText(msg);
        this.viewerCombo = new Combo(parent, style);
        this.viewerCombo.setLayoutData((Object)this.createGridDataWithSpan(0, 2));
        ComboViewer viewer = new ComboViewer(this.viewerCombo);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldIn, Object newIn) {
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setInput((Object)ITEMS);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String message = "Selected item: " + event.getSelection().toString();
                Shell shell = parent.getShell();
                MessageDialog.openInformation((Shell)shell, (String)"Info", (String)message);
            }
        });
        Menu menu = new Menu((Control)this.viewerCombo);
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText("MenuItem on ComboViewer");
        this.viewerCombo.setMenu(menu);
        int separatorStyle = 266;
        Label separator = new Label(parent, separatorStyle);
        separator.setLayoutData((Object)this.createGridDataWithSpan(768, 3));
        Label lblCCombo = new Label(parent, 0);
        lblCCombo.setText("CCombo");
        this.cCombo = new CCombo(parent, style);
        this.cCombo.setItems(ITEMS);
        this.cCombo.setEditable(this.checkControl((Control)this.editableButton) ? this.editableButton.getSelection() : true);
        if (this.hasCreateProperty(PROP_SELECTION_LISTENER)) {
            this.cCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    this.show(event, false);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.show(event, true);
                }

                private void show(SelectionEvent event, boolean defaultSelection) {
                    String type = defaultSelection ? "DefaultSelection" : "Selection";
                    String msg = String.valueOf(type) + ": " + event + "\n" + "Text: " + ComboTab.this.cCombo.getText() + "\n" + "Selection: " + ComboTab.this.cCombo.getSelectionIndex();
                    ComboTab.this.log(msg);
                }
            });
        }
        Button btnShowSelectionCCombo = new Button(parent, 8);
        btnShowSelectionCCombo.setText("Show Selection");
        btnShowSelectionCCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ComboTab.this.showSelection(ComboTab.this.cCombo.getItems(), ComboTab.this.cCombo.getSelectionIndex());
            }
        });
        this.registerControl((Control)this.firstCombo);
        this.registerControl((Control)this.verifyCombo);
        this.registerControl((Control)this.viewerCombo);
        this.registerControl((Control)this.cCombo);
    }

    private void createAddButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label lblAddItem = new Label(composite, 0);
        lblAddItem.setText("Add Item");
        final Text txtAddItem = new Text(composite, 2048);
        txtAddItem.setText("New Item");
        Button btnAddItem = new Button(composite, 8);
        btnAddItem.setText("Add");
        btnAddItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ComboTab.this.firstCombo.add(txtAddItem.getText());
            }
        });
    }

    private void createRemoveAllButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Remove All Items");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ComboTab.this.firstCombo.removeAll();
            }
        });
    }

    private void createDeselectAllButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Deselect All Items");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ComboTab.this.firstCombo.deselectAll();
            }
        });
    }

    private void createRemoveFirstItemButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Remove First Item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ComboTab.this.firstCombo.getItemCount() > 0) {
                    ComboTab.this.firstCombo.remove(0);
                }
            }
        });
    }

    private void createSelectFirstItemButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Select First Item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ComboTab.this.firstCombo.getItemCount() > 0) {
                    ComboTab.this.firstCombo.select(0);
                }
            }
        });
    }

    private void createSetVisibleItemCountButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        final Text text = new Text(composite, 2052);
        text.setText("3");
        text.setLayoutData((Object)new GridData(20, -1));
        Button button = new Button(composite, 8);
        button.setText("Set Visible Item Count");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    int vic = Integer.parseInt(text.getText());
                    ComboTab.this.firstCombo.setVisibleItemCount(vic);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
    }

    private void createSetSelectionControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(5, false));
        Label lblSelectionFrom = new Label(composite, 0);
        lblSelectionFrom.setText("From");
        final Text txtSelectionFrom = new Text(composite, 2052);
        txtSelectionFrom.setTextLimit(2);
        txtSelectionFrom.setText("0");
        txtSelectionFrom.setLayoutData((Object)new GridData(20, -1));
        Label lblSelectionTo = new Label(composite, 0);
        lblSelectionTo.setText("to");
        final Text txtSelectionTo = new Text(composite, 2052);
        txtSelectionTo.setTextLimit(2);
        txtSelectionTo.setText("0");
        txtSelectionTo.setLayoutData((Object)new GridData(20, -1));
        Button btnSetSelection = new Button(composite, 8);
        btnSetSelection.setText("set");
        btnSetSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int from = ComboTab.this.parseInt(txtSelectionFrom.getText());
                int to = ComboTab.this.parseInt(txtSelectionTo.getText());
                if (from >= 0 && to >= 0) {
                    ComboTab.this.firstCombo.setSelection(new Point(from, to));
                    ComboTab.this.firstCombo.setFocus();
                } else {
                    MessageDialog.openError((Shell)ComboTab.this.getShell(), (String)"Error", (String)"Invalid Selection");
                }
            }
        });
    }

    private void createGetSelectionControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        final Text outputSelection = new Text(composite, 2048);
        outputSelection.setEditable(false);
        Button btnGetSelection = new Button(composite, 8);
        btnGetSelection.setText("get");
        btnGetSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Point selection = ComboTab.this.firstCombo.getSelection();
                outputSelection.setText(String.valueOf(selection.x) + ", " + selection.y);
            }
        });
    }

    private int parseInt(String text) {
        int result;
        try {
            result = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            result = -1;
        }
        return result;
    }

    private void createSetTextLimitButton(Composite parent, final boolean isCombo) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        final Text text = new Text(composite, 2052);
        text.setText("5");
        text.setLayoutData((Object)new GridData(20, -1));
        Button button = new Button(composite, 8);
        button.setText("Set Text Limit");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    int textLimit = Integer.parseInt(text.getText());
                    if (isCombo) {
                        ComboTab.this.firstCombo.setTextLimit(textLimit);
                    } else {
                        ComboTab.this.cCombo.setTextLimit(textLimit);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
    }

    private void createChangeSizeButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Change Size");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private boolean customSize;

            public void widgetSelected(SelectionEvent event) {
                GridData gridData;
                if (this.customSize) {
                    gridData = new GridData(-1, -1);
                    ComboTab.this.cCombo.setLayoutData((Object)gridData);
                    this.customSize = false;
                } else {
                    gridData = new GridData(100, 100);
                    ComboTab.this.cCombo.setLayoutData((Object)gridData);
                    this.customSize = true;
                }
                Composite parent = ((Control)ComboTab.this.controls.get(0)).getParent();
                parent.layout(true, true);
            }
        });
    }

    private void createToggleListVisibilityButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Toggle List Visibility");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean listVisible = ComboTab.this.cCombo.getListVisible();
                ComboTab.this.cCombo.setListVisible(!listVisible);
            }
        });
    }

    private void createEditableButton(Composite parent) {
        this.editableButton = new Button(parent, 32);
        this.editableButton.setText("Editable");
        this.editableButton.setSelection(true);
        this.editableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComboTab.this.cCombo.setEditable(ComboTab.this.editableButton.getSelection());
            }
        });
    }

    private void createTextButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Change text");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ComboTab.this.cCombo.setText("foo");
            }
        });
    }

    private void showSelection(String[] items, int selectionIndex) {
        String selection = "(nothing)";
        if (selectionIndex != -1) {
            selection = items[selectionIndex];
        }
        String msg = "Your Selection: " + selection;
        MessageDialog.openInformation((Shell)this.getShell(), (String)"Information", (String)msg);
    }

    private GridData createGridDataWithSpan(int style, int span) {
        GridData gridData = new GridData(style);
        gridData.horizontalSpan = span;
        return gridData;
    }
}

