/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.scripting;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rap.rwt.internal.scripting.ClientFunction;
import org.eclipse.rap.rwt.internal.scripting.ClientListenerOperation;
import org.eclipse.rap.rwt.scripting.ClientListener;
import org.eclipse.swt.widgets.Widget;

public class ClientListenerUtil {
    private static final String OPERATIONS = "rwt.clientListenerOperations";

    public static String getRemoteId(ClientFunction function) {
        return function.getRemoteId();
    }

    public static String getEventType(int bindingType) {
        switch (bindingType) {
            case 2: {
                return "KeyUp";
            }
            case 1: {
                return "KeyDown";
            }
            case 15: {
                return "FocusIn";
            }
            case 16: {
                return "FocusOut";
            }
            case 3: {
                return "MouseDown";
            }
            case 4: {
                return "MouseUp";
            }
            case 6: {
                return "MouseEnter";
            }
            case 7: {
                return "MouseExit";
            }
            case 5: {
                return "MouseMove";
            }
            case 8: {
                return "MouseDoubleClick";
            }
            case 24: {
                return "Modify";
            }
            case 22: {
                return "Show";
            }
            case 23: {
                return "Hide";
            }
            case 25: {
                return "Verify";
            }
            case 9: {
                return "Paint";
            }
            case 11: {
                return "Resize";
            }
            case 13: {
                return "Selection";
            }
            case 14: {
                return "DefaultSelection";
            }
            case 37: {
                return "MouseWheel";
            }
        }
        throw new IllegalArgumentException("Unsupported event type " + bindingType);
    }

    public static void clientListenerAdded(Widget widget, int eventType, ClientListener listener) {
        List<ClientListenerOperation> operations = ClientListenerUtil.getClientListenerOperations(widget);
        if (operations == null) {
            operations = new ArrayList<ClientListenerOperation>(1);
            widget.setData(OPERATIONS, operations);
        }
        operations.add(new ClientListenerOperation.AddListener(eventType, listener));
    }

    public static void clientListenerRemoved(Widget widget, int eventType, ClientListener listener) {
        List<ClientListenerOperation> operations = ClientListenerUtil.getClientListenerOperations(widget);
        if (operations == null) {
            operations = new ArrayList<ClientListenerOperation>(1);
            widget.setData(OPERATIONS, operations);
        }
        operations.add(new ClientListenerOperation.RemoveListener(eventType, listener));
    }

    public static List<ClientListenerOperation> getClientListenerOperations(Widget widget) {
        return (List)widget.getData(OPERATIONS);
    }

    public static void clearClientListenerOperations(Widget widget) {
        widget.setData(OPERATIONS, null);
    }
}

