/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.event;

import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.equinox.internal.event.LogTrackerMsg;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class LogTracker
extends ServiceTracker<LogService, LogService> {
    protected static final String clazz = "org.osgi.service.log.LogService";
    private final PrintStream out;

    public LogTracker(BundleContext context, PrintStream out) {
        super(context, clazz, null);
        this.out = out;
    }

    public void log(int level, String message) {
        this.log(null, level, message, null);
    }

    public void log(int level, String message, Throwable exception) {
        this.log(null, level, message, exception);
    }

    public void log(ServiceReference<?> reference, int level, String message) {
        this.log(reference, level, message, null);
    }

    public synchronized void log(ServiceReference<?> reference, int level, String message, Throwable exception) {
        ServiceReference[] references = this.getServiceReferences();
        if (references != null) {
            int size = references.length;
            int i = 0;
            while (i < size) {
                LogService service = (LogService)this.getService(references[i]);
                if (service != null) {
                    try {
                        service.log(reference, level, message, exception);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                ++i;
            }
            return;
        }
        this.noLogService(level, message, exception, reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void noLogService(int level, String message, Throwable throwable, ServiceReference<?> reference) {
        if (this.out != null) {
            PrintStream printStream = this.out;
            synchronized (printStream) {
                String timestamp = this.getDate(new Date());
                this.out.print(timestamp + " ");
                switch (level) {
                    case 4: {
                        this.out.print(LogTrackerMsg.Debug);
                        break;
                    }
                    case 3: {
                        this.out.print(LogTrackerMsg.Info);
                        break;
                    }
                    case 2: {
                        this.out.print(LogTrackerMsg.Warning);
                        break;
                    }
                    case 1: {
                        this.out.print(LogTrackerMsg.Error);
                        break;
                    }
                    default: {
                        this.out.print("[");
                        this.out.print(LogTrackerMsg.Unknown_Log_level);
                        this.out.print("]: ");
                    }
                }
                this.out.println(message);
                if (reference != null) {
                    this.out.println(reference);
                }
                if (throwable != null) {
                    throwable.printStackTrace(this.out);
                }
            }
        }
    }

    private String getDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        StringBuilder sb = new StringBuilder();
        this.appendPaddedInt(c.get(1), 4, sb).append('-');
        this.appendPaddedInt(c.get(2) + 1, 2, sb).append('-');
        this.appendPaddedInt(c.get(5), 2, sb).append(' ');
        this.appendPaddedInt(c.get(11), 2, sb).append(':');
        this.appendPaddedInt(c.get(12), 2, sb).append(':');
        this.appendPaddedInt(c.get(13), 2, sb).append('.');
        this.appendPaddedInt(c.get(14), 3, sb);
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    private StringBuilder appendPaddedInt(int value, int pad, StringBuilder buffer) {
        if (--pad == 0) {
            return buffer.append(Integer.toString(value));
        }
        padding = (int)Math.pow(10.0, pad);
        if (value < padding) ** GOTO lbl9
        return buffer.append(Integer.toString(value));
lbl-1000:
        // 1 sources

        {
            buffer.append('0');
            padding /= 10;
lbl9:
            // 2 sources

            ** while (padding > value && padding > 1)
        }
lbl10:
        // 1 sources

        buffer.append(value);
        return buffer;
    }
}

