/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.servletbridge;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class CloseableURLClassLoader
extends URLClassLoader {
    private static final boolean CLOSEABLE_REGISTERED_AS_PARALLEL;
    static final String DOT_CLASS = ".class";
    static final String BANG_SLASH = "!/";
    static final String JAR = "jar";
    private static final String UNC_PREFIX = "//";
    private static final String SCHEME_FILE = "file";
    final ArrayList<CloseableJarFileLoader> loaders = new ArrayList();
    private final ArrayList<URL> loaderURLs = new ArrayList();
    boolean closed = false;
    private final AccessControlContext context;
    private final boolean verifyJars;
    private final boolean registeredAsParallel;
    private final Map<String, Thread> classNameLocks = new HashMap<String, Thread>(5);
    private final Object pkgLock = new Object();

    static {
        boolean registeredAsParallel;
        try {
            Method parallelCapableMetod = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", null);
            parallelCapableMetod.setAccessible(true);
            registeredAsParallel = (Boolean)parallelCapableMetod.invoke(null, null);
        }
        catch (Throwable e) {
            registeredAsParallel = true;
        }
        CLOSEABLE_REGISTERED_AS_PARALLEL = registeredAsParallel;
    }

    public CloseableURLClassLoader(URL[] urls) {
        this(urls, ClassLoader.getSystemClassLoader(), true);
    }

    public CloseableURLClassLoader(URL[] urls, ClassLoader parent) {
        this(CloseableURLClassLoader.excludeFileJarURLS(urls), parent, true);
    }

    public CloseableURLClassLoader(URL[] urls, ClassLoader parent, boolean verifyJars) {
        super(CloseableURLClassLoader.excludeFileJarURLS(urls), parent);
        this.registeredAsParallel = CLOSEABLE_REGISTERED_AS_PARALLEL && this.getClass() == CloseableURLClassLoader.class;
        this.context = AccessController.getContext();
        this.verifyJars = verifyJars;
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            if (CloseableURLClassLoader.isFileJarURL(url)) {
                this.loaderURLs.add(url);
                this.safeAddLoader(url);
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean safeAddLoader(URL url) {
        File file = new File(CloseableURLClassLoader.toURI(url));
        if (!file.exists()) return false;
        try {
            this.loaders.add(new CloseableJarFileLoader(file, this.verifyJars));
            return true;
        }
        catch (IOException iOException) {
            try {
                return false;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return false;
    }

    private static URI toURI(URL url) throws URISyntaxException {
        if (!SCHEME_FILE.equals(url.getProtocol())) {
            throw new IllegalArgumentException("bad prototcol: " + url.getProtocol());
        }
        Object pathString = url.toExternalForm().substring(5);
        if (((String)pathString).indexOf(47) != 0) {
            pathString = "/" + (String)pathString;
        } else if (((String)pathString).startsWith(UNC_PREFIX) && !((String)pathString).startsWith(UNC_PREFIX, 2)) {
            pathString = CloseableURLClassLoader.ensureUNCPath((String)pathString);
        }
        return new URI(SCHEME_FILE, null, (String)pathString, null);
    }

    private static String ensureUNCPath(String path) {
        int len = path.length();
        StringBuilder result = new StringBuilder(len);
        int i = 0;
        while (i < 4) {
            if (i >= len || result.length() > 0 || path.charAt(i) != '/') {
                result.append('/');
            }
            ++i;
        }
        result.append(path);
        return result.toString();
    }

    private static URL[] excludeFileJarURLS(URL[] urls) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            if (!CloseableURLClassLoader.isFileJarURL(url)) {
                urlList.add(url);
            }
            ++n2;
        }
        return urlList.toArray(new URL[urlList.size()]);
    }

    private static boolean isFileJarURL(URL url) {
        if (!url.getProtocol().equals(SCHEME_FILE)) {
            return false;
        }
        String path = url.getPath();
        return path == null || !path.endsWith("/");
    }

    @Override
    protected Class<?> findClass(final String name) throws ClassNotFoundException {
        try {
            Class clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Class<?> run() throws ClassNotFoundException {
                    String resourcePath = name.replace('.', '/') + CloseableURLClassLoader.DOT_CLASS;
                    CloseableJarFileLoader loader2 = null;
                    URL resourceURL = null;
                    ArrayList<CloseableJarFileLoader> arrayList = CloseableURLClassLoader.this.loaders;
                    synchronized (arrayList) {
                        block8: {
                            if (!CloseableURLClassLoader.this.closed) break block8;
                            return null;
                        }
                        for (CloseableJarFileLoader loader2 : CloseableURLClassLoader.this.loaders) {
                            resourceURL = loader2.getURL(resourcePath);
                            if (resourceURL != null) break;
                        }
                    }
                    if (resourceURL != null) {
                        try {
                            return CloseableURLClassLoader.this.defineClass(name, resourceURL, loader2.getManifest());
                        }
                        catch (IOException e) {
                            throw new ClassNotFoundException(name, e);
                        }
                    }
                    return null;
                }
            }, this.context);
            if (clazz != null) {
                return clazz;
            }
        }
        catch (PrivilegedActionException e) {
            throw (ClassNotFoundException)e.getException();
        }
        return super.findClass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Class<?> defineClass(String name, URL resourceURL, Manifest manifest) throws IOException {
        JarURLConnection connection = (JarURLConnection)resourceURL.openConnection();
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            String packageName = name.substring(0, lastDot);
            Object object = this.pkgLock;
            synchronized (object) {
                Package pkg = this.getPackage(packageName);
                if (pkg != null) {
                    this.checkForSealedPackage(pkg, packageName, manifest, connection.getJarFileURL());
                } else {
                    this.definePackage(packageName, manifest, connection.getJarFileURL());
                }
            }
        }
        JarEntry entry = connection.getJarEntry();
        byte[] bytes = new byte[(int)entry.getSize()];
        DataInputStream is = null;
        try {
            is = new DataInputStream(connection.getInputStream());
            is.readFully(bytes, 0, bytes.length);
            CodeSource cs = new CodeSource(connection.getJarFileURL(), entry.getCertificates());
            if (this.isRegisteredAsParallel()) {
                boolean initialLock = this.lockClassName(name);
                try {
                    Class<?> clazz = this.findLoadedClass(name);
                    if (clazz != null) {
                        Class<?> clazz2 = clazz;
                        return clazz2;
                    }
                    Class<?> clazz3 = this.defineClass(name, bytes, 0, bytes.length, cs);
                    return clazz3;
                }
                finally {
                    if (initialLock) {
                        this.unlockClassName(name);
                    }
                }
            }
            Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length, cs);
            return clazz;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void checkForSealedPackage(Package pkg, String packageName, Manifest manifest, URL jarFileURL) {
        if (pkg.isSealed()) {
            if (!pkg.isSealed(jarFileURL)) {
                throw new SecurityException("The package '" + packageName + "' was previously loaded and is already sealed.");
            }
        } else {
            Attributes mainAttributes;
            String entryPath = packageName.replace('.', '/') + "/";
            Attributes entryAttributes = manifest.getAttributes(entryPath);
            String sealed = null;
            if (entryAttributes != null) {
                sealed = entryAttributes.getValue(Attributes.Name.SEALED);
            }
            if (sealed == null && (mainAttributes = manifest.getMainAttributes()) != null) {
                sealed = mainAttributes.getValue(Attributes.Name.SEALED);
            }
            if (Boolean.valueOf(sealed).booleanValue()) {
                throw new SecurityException("The package '" + packageName + "' was previously loaded unsealed. Cannot seal package.");
            }
        }
    }

    @Override
    public URL findResource(final String name) {
        URL url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public URL run() {
                ArrayList<CloseableJarFileLoader> arrayList = CloseableURLClassLoader.this.loaders;
                synchronized (arrayList) {
                    block5: {
                        if (!CloseableURLClassLoader.this.closed) break block5;
                        return null;
                    }
                    for (CloseableJarFileLoader loader : CloseableURLClassLoader.this.loaders) {
                        URL resourceURL = loader.getURL(name);
                        if (resourceURL == null) continue;
                        return resourceURL;
                    }
                }
                return null;
            }
        }, this.context);
        if (url != null) {
            return url;
        }
        return super.findResource(name);
    }

    @Override
    public Enumeration<URL> findResources(final String name) throws IOException {
        final ArrayList<URL> resources = new ArrayList<URL>();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() {
                ArrayList<CloseableJarFileLoader> arrayList = CloseableURLClassLoader.this.loaders;
                synchronized (arrayList) {
                    block5: {
                        if (!CloseableURLClassLoader.this.closed) break block5;
                        return null;
                    }
                    for (CloseableJarFileLoader loader : CloseableURLClassLoader.this.loaders) {
                        URL resourceURL = loader.getURL(name);
                        if (resourceURL == null) continue;
                        resources.add(resourceURL);
                    }
                }
                return null;
            }
        }, this.context);
        Enumeration<URL> e = super.findResources(name);
        while (e.hasMoreElements()) {
            resources.add(e.nextElement());
        }
        return Collections.enumeration(resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<CloseableJarFileLoader> arrayList = this.loaders;
        synchronized (arrayList) {
            if (this.closed) {
                return;
            }
            for (CloseableJarFileLoader loader : this.loaders) {
                loader.close();
            }
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addURL(URL url) {
        ArrayList<CloseableJarFileLoader> arrayList = this.loaders;
        synchronized (arrayList) {
            if (CloseableURLClassLoader.isFileJarURL(url)) {
                if (this.closed) {
                    throw new IllegalStateException("Cannot add url. CloseableURLClassLoader is closed.");
                }
                this.loaderURLs.add(url);
                if (this.safeAddLoader(url)) {
                    return;
                }
            }
        }
        super.addURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL[] getURLs() {
        ArrayList<URL> result = new ArrayList<URL>();
        ArrayList<CloseableJarFileLoader> arrayList = this.loaders;
        synchronized (arrayList) {
            result.addAll(this.loaderURLs);
        }
        result.addAll(Arrays.asList(super.getURLs()));
        return result.toArray(new URL[result.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean lockClassName(String classname) {
        Map<String, Thread> map = this.classNameLocks;
        synchronized (map) {
            Thread lockingThread = this.classNameLocks.get(classname);
            Thread current = Thread.currentThread();
            if (lockingThread == current) {
                return false;
            }
            boolean previousInterruption = Thread.interrupted();
            try {
                while (true) {
                    if (lockingThread == null) {
                        this.classNameLocks.put(classname, current);
                        return true;
                    }
                    this.classNameLocks.wait();
                    lockingThread = this.classNameLocks.get(classname);
                    continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                current.interrupt();
                throw (LinkageError)new LinkageError(classname).initCause(e);
            }
            finally {
                if (previousInterruption) {
                    current.interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockClassName(String classname) {
        Map<String, Thread> map = this.classNameLocks;
        synchronized (map) {
            this.classNameLocks.remove(classname);
            this.classNameLocks.notifyAll();
        }
    }

    protected boolean isRegisteredAsParallel() {
        return this.registeredAsParallel;
    }

    private static class CloseableJarFileLoader {
        private final JarFile jarFile;
        private final Manifest manifest;
        private final CloseableJarURLStreamHandler jarURLStreamHandler;
        private final String jarFileURLPrefixString;

        public CloseableJarFileLoader(File file, boolean verify) throws IOException {
            this.jarFile = new JarFile(file, verify);
            this.manifest = this.jarFile.getManifest();
            this.jarURLStreamHandler = new CloseableJarURLStreamHandler(this.jarFile);
            this.jarFileURLPrefixString = file.toURL().toString() + CloseableURLClassLoader.BANG_SLASH;
        }

        public URL getURL(String name) {
            if (this.jarFile.getEntry(name) != null) {
                try {
                    return new URL(CloseableURLClassLoader.JAR, null, -1, this.jarFileURLPrefixString + name, this.jarURLStreamHandler);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }

        public Manifest getManifest() {
            return this.manifest;
        }

        public void close() {
            try {
                this.jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class CloseableJarURLConnection
    extends JarURLConnection {
        private final JarFile jarFile;
        private JarEntry entry;

        public CloseableJarURLConnection(URL url, JarFile jarFile) throws MalformedURLException {
            super(url);
            this.jarFile = jarFile;
        }

        @Override
        public void connect() throws IOException {
            this.internalGetEntry();
        }

        private synchronized JarEntry internalGetEntry() throws IOException {
            if (this.entry != null) {
                return this.entry;
            }
            this.entry = this.jarFile.getJarEntry(this.getEntryName());
            if (this.entry == null) {
                throw new FileNotFoundException(this.getEntryName());
            }
            return this.entry;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.jarFile.getInputStream(this.internalGetEntry());
        }

        @Override
        public JarFile getJarFile() throws IOException {
            return this.jarFile;
        }

        @Override
        public JarEntry getJarEntry() throws IOException {
            return this.internalGetEntry();
        }
    }

    private static class CloseableJarURLStreamHandler
    extends URLStreamHandler {
        private final JarFile jarFile;

        public CloseableJarURLStreamHandler(JarFile jarFile) {
            this.jarFile = jarFile;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new CloseableJarURLConnection(u, this.jarFile);
        }

        @Override
        protected void parseURL(URL u, String spec, int start, int limit) {
            this.setURL(u, CloseableURLClassLoader.JAR, null, 0, null, null, spec.substring(start, limit), null, null);
        }
    }
}

