/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.buttonkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.util.MnemonicUtil;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.internal.widgets.MarkupUtil;
import org.eclipse.swt.internal.widgets.buttonkit.ButtonOperationHandler;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Widget;

public final class ButtonLCA
extends WidgetLCA<Button> {
    public static final ButtonLCA INSTANCE = new ButtonLCA();
    private static final String TYPE = "rwt.widgets.Button";
    private static final String[] ALLOWED_STYLES = new String[]{"ARROW", "CHECK", "PUSH", "RADIO", "TOGGLE", "FLAT", "WRAP", "BORDER"};
    private static final String PROP_TEXT = "text";
    private static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_GRAYED = "grayed";
    private static final String PROP_ALIGNMENT = "alignment";
    private static final String PROP_MARKUP_ENABLED = "markupEnabled";
    private static final String PROP_BADGE = "badge";
    private static final String DEFAULT_ALIGNMENT = "center";

    @Override
    public void preserveValues(Button button) {
        WidgetLCAUtil.preserveProperty((Widget)button, PROP_TEXT, button.getText());
        WidgetLCAUtil.preserveProperty((Widget)button, PROP_IMAGE, button.getImage());
        WidgetLCAUtil.preserveProperty((Widget)button, PROP_SELECTION, (Object)button.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)button, PROP_GRAYED, (Object)button.getGrayed());
        WidgetLCAUtil.preserveProperty((Widget)button, PROP_ALIGNMENT, ButtonLCA.getAlignment(button));
        WidgetLCAUtil.preserveProperty((Widget)button, PROP_BADGE, ButtonLCA.getBadge(button));
    }

    @Override
    public void renderInitialization(Button button) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(button, TYPE);
        remoteObject.setHandler(new ButtonOperationHandler(button));
        remoteObject.set("parent", WidgetUtil.getId(button.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(button, ALLOWED_STYLES)));
        WidgetLCAUtil.renderProperty((Widget)button, PROP_MARKUP_ENABLED, MarkupUtil.isMarkupEnabledFor(button), false);
    }

    @Override
    public void renderChanges(Button button) throws IOException {
        ControlLCAUtil.renderChanges(button);
        WidgetLCAUtil.renderCustomVariant(button);
        ButtonLCA.renderText(button);
        ButtonLCA.renderMnemonicIndex(button);
        WidgetLCAUtil.renderProperty((Widget)button, PROP_IMAGE, button.getImage(), null);
        WidgetLCAUtil.renderProperty((Widget)button, PROP_ALIGNMENT, ButtonLCA.getAlignment(button), DEFAULT_ALIGNMENT);
        WidgetLCAUtil.renderProperty((Widget)button, PROP_SELECTION, button.getSelection(), false);
        WidgetLCAUtil.renderProperty((Widget)button, PROP_GRAYED, button.getGrayed(), false);
        WidgetLCAUtil.renderProperty((Widget)button, PROP_BADGE, ButtonLCA.getBadge(button), null);
        WidgetLCAUtil.renderListenSelection(button);
        WidgetLCAUtil.renderClientListeners(button);
    }

    private static String getAlignment(Button button) {
        int alignment = button.getAlignment();
        String result = (alignment & 0x4000) != 0 ? "left" : ((alignment & 0x1000000) != 0 ? DEFAULT_ALIGNMENT : ((alignment & 0x20000) != 0 ? "right" : ((alignment & 0x80) != 0 ? "up" : ((alignment & 0x400) != 0 ? "down" : "left"))));
        return result;
    }

    private static String getBadge(Button button) {
        return (String)button.getData("org.eclipse.rap.rwt.badge");
    }

    private static void renderText(Button button) {
        String newValue = button.getText();
        if (WidgetLCAUtil.hasChanged(button, PROP_TEXT, newValue, "")) {
            String text = MnemonicUtil.removeAmpersandControlCharacters(newValue);
            RemoteObjectFactory.getRemoteObject(button).set(PROP_TEXT, text);
        }
    }

    private static void renderMnemonicIndex(Button button) {
        int mnemonicIndex;
        String text = button.getText();
        if (WidgetLCAUtil.hasChanged(button, PROP_TEXT, text, "") && (mnemonicIndex = MnemonicUtil.findMnemonicCharacterIndex(text)) != -1) {
            RemoteObjectFactory.getRemoteObject(button).set(PROP_MNEMONIC_INDEX, mnemonicIndex);
        }
    }

    private ButtonLCA() {
    }
}

