/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.framework.util.ArrayMap;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.hookregistry.ActivatorHookFactory;
import org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.internal.url.MultiplexingFactory;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.ContentProvider;
import org.eclipse.osgi.storage.StorageUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;

public class FrameworkExtensionInstaller {
    private static final ClassLoader CL = FrameworkExtensionInstaller.class.getClassLoader();
    private static final Method ADD_FWK_URL_METHOD = FrameworkExtensionInstaller.findAddURLMethod(CL, "addURL");
    private static final Method ADD_FWK_FILE_PATH_METHOD = ADD_FWK_URL_METHOD == null ? FrameworkExtensionInstaller.findAddFilePathMethod(CL, "appendToClassPathForInstrumentation") : null;
    private final ArrayMap<BundleActivator, Bundle> hookActivators = new ArrayMap(5);
    private final EquinoxConfiguration configuration;

    private static Method findAddURLMethod(ClassLoader cl, String name) {
        if (cl == null) {
            return null;
        }
        return FrameworkExtensionInstaller.findMethod(cl.getClass(), name, new Class[]{URL.class}, MultiplexingFactory.setAccessible);
    }

    private static Method findAddFilePathMethod(ClassLoader cl, String name) {
        if (cl == null) {
            return null;
        }
        return FrameworkExtensionInstaller.findMethod(cl.getClass(), name, new Class[]{String.class}, MultiplexingFactory.setAccessible);
    }

    private static Method findMethod(Class<?> clazz, String name, Class<?>[] args, Collection<AccessibleObject> setAccessible) {
        if (clazz == null) {
            return null;
        }
        try {
            Method result = clazz.getDeclaredMethod(name, args);
            if (setAccessible != null) {
                setAccessible.add(result);
            } else {
                result.setAccessible(true);
            }
            return result;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException | RuntimeException exception) {}
        return FrameworkExtensionInstaller.findMethod(clazz.getSuperclass(), name, args, setAccessible);
    }

    private static void callAddURLMethod(URL arg) throws InvocationTargetException {
        try {
            ADD_FWK_URL_METHOD.invoke((Object)CL, arg);
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t);
        }
    }

    private static void callAddFilePathMethod(File file) throws InvocationTargetException {
        try {
            ADD_FWK_FILE_PATH_METHOD.invoke((Object)CL, file.getCanonicalPath());
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t);
        }
    }

    public FrameworkExtensionInstaller(EquinoxConfiguration configuraiton) {
        this.configuration = configuraiton;
    }

    public void addExtensionContent(Collection<ModuleRevision> revisions, Module systemModule) throws BundleException {
        if (System.getSecurityManager() == null) {
            this.addExtensionContent0(revisions, systemModule);
        } else {
            try {
                AccessController.doPrivileged(() -> {
                    this.addExtensionContent0(revisions, systemModule);
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw (BundleException)e.getCause();
            }
        }
    }

    void addExtensionContent0(Collection<ModuleRevision> revisions, Module systemModule) throws BundleException {
        if (revisions.isEmpty()) {
            return;
        }
        for (ModuleRevision revision : revisions) {
            File[] files;
            if (CL == null || ADD_FWK_URL_METHOD == null && ADD_FWK_FILE_PATH_METHOD == null) {
                throw new BundleException("Cannot support framework extension bundles without a public addURL(URL) or appendToClassPathForInstrumentation(String) method on the framework class loader: " + revision.getBundle());
            }
            File[] fileArray = files = this.getExtensionFiles(revision);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file != null) {
                    try {
                        if (ADD_FWK_URL_METHOD != null) {
                            FrameworkExtensionInstaller.callAddURLMethod(StorageUtil.encodeFileURL(file));
                        } else if (ADD_FWK_FILE_PATH_METHOD != null) {
                            FrameworkExtensionInstaller.callAddFilePathMethod(file);
                        }
                    }
                    catch (InvocationTargetException | MalformedURLException e) {
                        throw new BundleException("Error adding extension content. " + revision, e);
                    }
                }
                ++n2;
            }
        }
        if (CL != null) {
            try {
                CL.loadClass("thisIsNotAClass");
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (systemModule != null) {
            BundleContext systemContext = systemModule.getBundle().getBundleContext();
            for (ModuleRevision revision : revisions) {
                if (systemContext == null) continue;
                this.startExtensionActivator(revision, systemContext);
            }
        }
    }

    private File[] getExtensionFiles(ModuleRevision revision) {
        ArrayList<String> paths;
        BundleInfo.Generation generation = (BundleInfo.Generation)revision.getRevisionInfo();
        if (generation.getContentType() == ContentProvider.Type.CONNECT) {
            return new File[0];
        }
        List<ModuleCapability> metaDatas = revision.getModuleCapabilities("equinox.module.data");
        ArrayList<String> arrayList = paths = metaDatas.isEmpty() ? null : (ArrayList<String>)metaDatas.get(0).getAttributes().get("classpath");
        if (paths == null) {
            paths = new ArrayList<String>(1);
            paths.add(".");
        }
        if (this.configuration.inDevelopmentMode()) {
            paths = new ArrayList(paths);
            String[] devPaths = this.configuration.getDevClassPath(revision.getSymbolicName());
            Collections.addAll(paths, devPaths);
        }
        ArrayList<File> results = new ArrayList<File>(paths.size());
        for (String path : paths) {
            if (".".equals(path)) {
                results.add(((BundleInfo.Generation)revision.getRevisionInfo()).getBundleFile().getBaseFile());
                continue;
            }
            File result = ((BundleInfo.Generation)revision.getRevisionInfo()).getBundleFile().getFile(path, false);
            if (result == null) continue;
            results.add(result);
        }
        return results.toArray(new File[results.size()]);
    }

    public void startExtensionActivators(BundleContext context) {
        HookRegistry hookRegistry = this.configuration.getHookRegistry();
        List<ActivatorHookFactory> activatorHookFactories = hookRegistry.getActivatorHookFactories();
        for (ActivatorHookFactory activatorFactory : activatorHookFactories) {
            BundleActivator activator = activatorFactory.createActivator();
            try {
                this.startActivator(activator, context, null);
            }
            catch (Exception e) {
                this.configuration.getHookRegistry().getContainer().getEventPublisher().publishFrameworkEvent(2, null, e);
            }
        }
        ModuleWiring systemWiring = (ModuleWiring)context.getBundle().adapt(BundleWiring.class);
        if (systemWiring != null) {
            List<ModuleWire> extensionWires = systemWiring.getProvidedModuleWires("osgi.wiring.host");
            for (ModuleWire extensionWire : extensionWires) {
                ModuleRevision extensionRevision = extensionWire.getRequirer();
                this.startExtensionActivator(extensionRevision, context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopExtensionActivators(BundleContext context) {
        ArrayMap<BundleActivator, Bundle> current;
        ArrayMap<BundleActivator, Bundle> arrayMap = this.hookActivators;
        synchronized (arrayMap) {
            current = new ArrayMap<BundleActivator, Bundle>(this.hookActivators.getKeys(), this.hookActivators.getValues());
            this.hookActivators.clear();
        }
        int i = current.getKeys().size() - 1;
        while (i >= 0) {
            BundleActivator activator = current.getKey(i);
            try {
                activator.stop(context);
            }
            catch (Exception e) {
                Bundle b = current.get(activator);
                BundleException eventException = new BundleException(NLS.bind(Msg.BUNDLE_ACTIVATOR_EXCEPTION, new Object[]{activator.getClass(), "stop", b == null ? "" : b.getSymbolicName()}), 5, e);
                this.configuration.getHookRegistry().getContainer().getEventPublisher().publishFrameworkEvent(2, b, eventException);
            }
            --i;
        }
    }

    private void startExtensionActivator(ModuleRevision extensionRevision, BundleContext context) {
        List<Capability> metadata = extensionRevision.getCapabilities("equinox.module.data");
        if (metadata.isEmpty()) {
            return;
        }
        String activatorName = (String)metadata.get(0).getAttributes().get("activator");
        if (activatorName == null) {
            return;
        }
        BundleActivator activator = null;
        try {
            Class<?> activatorClass = Class.forName(activatorName);
            activator = (BundleActivator)activatorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.startActivator(activator, context, extensionRevision.getBundle());
        }
        catch (Throwable e) {
            BundleException eventException = activator == null ? new BundleException(String.valueOf(Msg.BundleContextImpl_LoadActivatorError) + ' ' + extensionRevision, 5, e) : new BundleException(NLS.bind(Msg.BUNDLE_ACTIVATOR_EXCEPTION, new Object[]{activator.getClass(), "start", extensionRevision.getSymbolicName()}), 5, e);
            this.configuration.getHookRegistry().getContainer().getEventPublisher().publishFrameworkEvent(2, extensionRevision.getBundle(), eventException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startActivator(BundleActivator activator, BundleContext context, Bundle b) throws Exception {
        activator.start(context);
        ArrayMap<BundleActivator, Bundle> arrayMap = this.hookActivators;
        synchronized (arrayMap) {
            this.hookActivators.put(activator, b);
        }
    }
}

