/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.Topic;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.toc.Toc;

public class TopicSorter {
    private TopicComparator comparator;

    public void sortChildren(Toc toc) {
        if (this.comparator == null) {
            this.comparator = new TopicComparator();
        }
        if (toc.isSorted()) {
            this.sort(toc, toc.getTopics());
        }
        ITopic[] childTopics = toc.getTopics();
        int i = 0;
        while (i < childTopics.length) {
            this.sortChildren((Topic)childTopics[i]);
            ++i;
        }
    }

    private void sortChildren(Topic topic) {
        if (topic.isSorted()) {
            this.sort(topic, topic.getSubtopics());
        }
        ITopic[] childTopics = topic.getSubtopics();
        int i = 0;
        while (i < childTopics.length) {
            this.sortChildren((Topic)childTopics[i]);
            ++i;
        }
    }

    private void sort(UAElement element, ITopic[] children) {
        if (children.length > 1) {
            int i = 0;
            while (i < children.length) {
                element.removeChild((UAElement)((Object)children[i]));
                ++i;
            }
            Arrays.sort(children, this.comparator);
            i = 0;
            while (i < children.length) {
                element.appendChild((UAElement)((Object)children[i]));
                ++i;
            }
        }
    }

    private class TopicComparator
    implements Comparator<ITopic> {
        Collator collator = Collator.getInstance();

        private TopicComparator() {
        }

        @Override
        public int compare(ITopic o1, ITopic o2) {
            String label1 = o1.getLabel();
            String label2 = o2.getLabel();
            return this.collator.compare(label1, label2);
        }
    }
}

