/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.ccombokit;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.ControlOperationHandler;
import org.eclipse.rap.rwt.remote.JsonMapping;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.ITextAdapter;
import org.eclipse.swt.widgets.Event;

public class CComboOperationHandler
extends ControlOperationHandler<CCombo> {
    private static final String PROP_SELECTION_INDEX = "selectionIndex";
    private static final String PROP_LIST_VISIBLE = "listVisible";
    private static final String PROP_TEXT = "text";
    private static final String PROP_SELECTION = "selection";

    public CComboOperationHandler(CCombo ccombo) {
        super(ccombo);
    }

    @Override
    public void handleSet(CCombo ccombo, JsonObject properties) {
        super.handleSet(ccombo, properties);
        this.handleSetSelectionIndex(ccombo, properties);
        this.handleSetListVisible(ccombo, properties);
        this.handleSetText(ccombo, properties);
        this.handleSetSelection(ccombo, properties);
    }

    @Override
    public void handleNotify(CCombo ccombo, String eventName, JsonObject properties) {
        if ("Selection".equals(eventName)) {
            this.handleNotifySelection(ccombo, properties);
        } else if ("DefaultSelection".equals(eventName)) {
            this.handleNotifyDefaultSelection(ccombo, properties);
        } else if ("Modify".equals(eventName)) {
            this.handleNotifyModify(ccombo, properties);
        } else {
            super.handleNotify(ccombo, eventName, properties);
        }
    }

    public void handleSetSelectionIndex(CCombo ccombo, JsonObject properties) {
        JsonValue selectionIndex = properties.get(PROP_SELECTION_INDEX);
        if (selectionIndex != null) {
            ccombo.select(selectionIndex.asInt());
        }
    }

    public void handleSetListVisible(CCombo ccombo, JsonObject properties) {
        JsonValue listVisible = properties.get(PROP_LIST_VISIBLE);
        if (listVisible != null) {
            ccombo.setListVisible(listVisible.asBoolean());
        }
    }

    public void handleSetText(final CCombo ccombo, JsonObject properties) {
        JsonValue value = properties.get(PROP_TEXT);
        if (value != null) {
            final String text = value.asString();
            if (EventLCAUtil.isListening(ccombo, 25)) {
                ProcessActionRunner.add(new Runnable(){

                    @Override
                    public void run() {
                        if (!ccombo.isDisposed()) {
                            CComboOperationHandler.setText(ccombo, text);
                            WidgetUtil.getAdapter(ccombo).preserve(CComboOperationHandler.PROP_TEXT, text);
                        }
                    }
                });
            } else {
                CComboOperationHandler.setText(ccombo, text);
            }
        }
    }

    public void handleSetSelection(final CCombo ccombo, JsonObject properties) {
        JsonValue value = properties.get(PROP_SELECTION);
        if (value != null) {
            final Point selection = JsonMapping.readPoint(value);
            if (EventLCAUtil.isListening(ccombo, 25)) {
                ProcessActionRunner.add(new Runnable(){

                    @Override
                    public void run() {
                        if (!ccombo.isDisposed()) {
                            ccombo.setSelection(selection);
                            WidgetUtil.getAdapter(ccombo).preserve(CComboOperationHandler.PROP_SELECTION, ccombo.getSelection());
                        }
                    }
                });
            } else {
                ccombo.setSelection(selection);
            }
        }
    }

    public void handleNotifySelection(CCombo ccombo, JsonObject properties) {
        Event event = CComboOperationHandler.createSelectionEvent(13, properties);
        ccombo.notifyListeners(13, event);
    }

    public void handleNotifyDefaultSelection(CCombo ccombo, JsonObject properties) {
        Event event = CComboOperationHandler.createSelectionEvent(14, properties);
        ccombo.notifyListeners(14, event);
    }

    public void handleNotifyModify(CCombo ccombo, JsonObject properties) {
    }

    private static void setText(CCombo ccombo, String value) {
        if (!ccombo.getText().equals(value)) {
            ccombo.getAdapter(ITextAdapter.class).setText(value);
        }
    }
}

