/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.theme.CssFont;
import org.eclipse.rap.rwt.internal.theme.CssValue;
import org.eclipse.rap.rwt.internal.theme.SimpleSelector;
import org.eclipse.rap.rwt.internal.theme.ThemeUtil;
import org.eclipse.rap.rwt.internal.util.SerializableLock;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.graphics.ResourceFactory;

public abstract class Device
implements Drawable,
SerializableCompatibility {
    protected final SerializableLock deviceLock = new SerializableLock();
    private boolean disposed;

    public Color getSystemColor(int id) {
        Color result;
        this.checkDevice();
        ResourceFactory resourceFactory = ContextProvider.getApplicationContext().getResourceFactory();
        switch (id) {
            case 1: {
                result = resourceFactory.getColor(255, 255, 255);
                break;
            }
            case 2: {
                result = resourceFactory.getColor(0, 0, 0);
                break;
            }
            case 3: {
                result = resourceFactory.getColor(255, 0, 0);
                break;
            }
            case 4: {
                result = resourceFactory.getColor(128, 0, 0);
                break;
            }
            case 5: {
                result = resourceFactory.getColor(0, 255, 0);
                break;
            }
            case 6: {
                result = resourceFactory.getColor(0, 128, 0);
                break;
            }
            case 7: {
                result = resourceFactory.getColor(255, 255, 0);
                break;
            }
            case 8: {
                result = resourceFactory.getColor(128, 128, 0);
                break;
            }
            case 9: {
                result = resourceFactory.getColor(0, 0, 255);
                break;
            }
            case 10: {
                result = resourceFactory.getColor(0, 0, 128);
                break;
            }
            case 11: {
                result = resourceFactory.getColor(255, 0, 255);
                break;
            }
            case 12: {
                result = resourceFactory.getColor(128, 0, 128);
                break;
            }
            case 13: {
                result = resourceFactory.getColor(0, 255, 255);
                break;
            }
            case 14: {
                result = resourceFactory.getColor(0, 128, 128);
                break;
            }
            case 15: {
                result = resourceFactory.getColor(192, 192, 192);
                break;
            }
            case 16: {
                result = resourceFactory.getColor(128, 128, 128);
                break;
            }
            default: {
                result = resourceFactory.getColor(0, 0, 0);
            }
        }
        return result;
    }

    public Font getSystemFont() {
        this.checkDevice();
        CssValue font = ThemeUtil.getCssValue("Display", "font", SimpleSelector.DEFAULT);
        return CssFont.createFont((CssFont)font);
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        FontData[] result;
        block7: {
            this.checkDevice();
            result = new FontData[]{};
            if (!scalable) break block7;
            CssFont fontList = (CssFont)ThemeUtil.getCssValue("Display", "rwt-fontlist", SimpleSelector.DEFAULT);
            if (faceName == null) {
                result = new FontData[fontList.family.length];
                int i = 0;
                while (i < result.length) {
                    result[i] = new FontData(fontList.family[i], 0, 0);
                    ++i;
                }
            } else {
                int counter = 0;
                int i = 0;
                while (i < fontList.family.length) {
                    if (fontList.family[i].startsWith(faceName)) {
                        ++counter;
                    }
                    ++i;
                }
                result = new FontData[counter];
                counter = 0;
                i = 0;
                while (i < fontList.family.length) {
                    if (fontList.family[i].startsWith(faceName)) {
                        result[counter++] = new FontData(fontList.family[i], 0, 0);
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        return 16;
    }

    public Point getDPI() {
        this.checkDevice();
        return new Point(0, 0);
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        SerializableLock serializableLock = this.deviceLock;
        synchronized (serializableLock) {
            if (!this.isDisposed()) {
                this.checkDevice();
                this.release();
                this.destroy();
                this.disposed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        SerializableLock serializableLock = this.deviceLock;
        synchronized (serializableLock) {
            return this.disposed;
        }
    }

    protected void release() {
    }

    protected void destroy() {
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }
}

