/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import org.eclipse.swt.internal.widgets.Decorator;
import org.eclipse.swt.internal.widgets.IControlHolderAdapter;
import org.eclipse.swt.internal.widgets.IShellAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.MenuHolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Widget;

public class WidgetTreeVisitor {
    public static void accept(Widget root, WidgetTreeVisitor visitor) {
        if (root instanceof Composite) {
            Composite composite = (Composite)root;
            if (visitor.visit(composite)) {
                WidgetTreeVisitor.handleMenus(composite, visitor);
                WidgetTreeVisitor.handleDragDrop(root, visitor);
                WidgetTreeVisitor.handleDecorator(root, visitor);
                WidgetTreeVisitor.handleItems(root, visitor);
                WidgetTreeVisitor.handleChildren(composite, visitor);
                WidgetTreeVisitor.handleToolTips(root, visitor);
            }
        } else if (ItemHolder.isItemHolder(root)) {
            if (visitor.visit(root)) {
                WidgetTreeVisitor.handleDragDrop(root, visitor);
                WidgetTreeVisitor.handleDecorator(root, visitor);
                WidgetTreeVisitor.handleItems(root, visitor);
            }
        } else if (visitor.visit(root)) {
            WidgetTreeVisitor.handleDragDrop(root, visitor);
            WidgetTreeVisitor.handleDecorator(root, visitor);
        }
    }

    public boolean visit(Widget widget) {
        return true;
    }

    public boolean visit(Composite composite) {
        return true;
    }

    private static void handleMenus(Composite composite, WidgetTreeVisitor visitor) {
        if (MenuHolder.isMenuHolder(composite)) {
            Menu[] menus = MenuHolder.getMenus(composite);
            int i = 0;
            while (i < menus.length) {
                WidgetTreeVisitor.accept(menus[i], visitor);
                ++i;
            }
        }
    }

    private static void handleDragDrop(Widget widget, WidgetTreeVisitor visitor) {
        if (widget instanceof Control) {
            Widget dropTarget;
            Widget dragSource = (Widget)widget.getData("DragSource");
            if (dragSource != null) {
                visitor.visit(dragSource);
            }
            if ((dropTarget = (Widget)widget.getData("DropTarget")) != null) {
                visitor.visit(dropTarget);
            }
        }
    }

    private static void handleDecorator(Widget root, WidgetTreeVisitor visitor) {
        Decorator[] decorators = Decorator.getDecorators(root);
        int i = 0;
        while (i < decorators.length) {
            visitor.visit(decorators[i]);
            ++i;
        }
    }

    private static void handleItems(Widget root, WidgetTreeVisitor visitor) {
        if (ItemHolder.isItemHolder(root)) {
            Item[] items = ItemHolder.getItemHolder(root).getItems();
            int i = 0;
            while (i < items.length) {
                WidgetTreeVisitor.accept(items[i], visitor);
                ++i;
            }
        }
    }

    private static void handleChildren(Composite composite, WidgetTreeVisitor visitor) {
        IControlHolderAdapter adapter = composite.getAdapter(IControlHolderAdapter.class);
        Control[] children = adapter.getControls();
        int i = 0;
        while (i < children.length) {
            WidgetTreeVisitor.accept(children[i], visitor);
            ++i;
        }
    }

    private static void handleToolTips(Widget root, WidgetTreeVisitor visitor) {
        IShellAdapter adapter = root.getAdapter(IShellAdapter.class);
        if (adapter != null) {
            IShellAdapter shellAdapter = adapter;
            ToolTip[] toolTips = shellAdapter.getToolTips();
            int i = 0;
            while (i < toolTips.length) {
                visitor.visit(toolTips[i]);
                ++i;
            }
        }
    }

    public static abstract class AllWidgetTreeVisitor
    extends WidgetTreeVisitor {
        @Override
        public final boolean visit(Widget widget) {
            return this.doVisit(widget);
        }

        @Override
        public final boolean visit(Composite composite) {
            return this.doVisit(composite);
        }

        public abstract boolean doVisit(Widget var1);
    }
}

