/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.config;

import java.text.MessageFormat;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;
import org.eclipse.rap.ui.internal.launch.rwt.config.ValidationResult;
import org.eclipse.rap.ui.internal.launch.rwt.config.Validator;

class ProjectValidator
extends Validator {
    static final int ERR_PROJECT_NOT_JAVA = 8001;

    ProjectValidator(RWTLaunchConfig config, ValidationResult validationResult) {
        super(config, validationResult);
    }

    void validate() {
        String projectName = this.config.getProjectName();
        if (this.isProjectNameSpecified(projectName) && ProjectValidator.isValidProjectName(projectName) && !ProjectValidator.isExistingJavaProject(projectName)) {
            String text = "The project {0} does not exist.";
            String msg = MessageFormat.format(text, projectName);
            this.addError(msg, 8001);
        }
    }

    private boolean isProjectNameSpecified(String projectName) {
        return projectName.length() > 0;
    }

    private static boolean isExistingJavaProject(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return JavaCore.create((IWorkspaceRoot)root).getJavaProject(projectName).exists();
    }

    private static boolean isValidProjectName(String projectName) {
        IPath projectPath = new Path(null, projectName).makeAbsolute();
        return projectPath.segmentCount() == 1;
    }
}

