/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.protocol;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.rwt.internal.protocol.JsonUtil;
import org.eclipse.rwt.internal.theme.JsonArray;
import org.eclipse.rwt.internal.theme.JsonValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Operation {
    private final String action;
    private final String target;
    private final Map<String, Object> details;
    private final Map<String, JsonValue> properties;

    Operation(String target, String action) {
        this.target = target;
        this.action = action;
        this.details = new LinkedHashMap<String, Object>();
        this.properties = new LinkedHashMap<String, JsonValue>();
    }

    String getTarget() {
        return this.target;
    }

    String getAction() {
        return this.action;
    }

    void appendProperty(String key, JsonValue value) {
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicate property " + key);
        }
        this.properties.put(key, value);
    }

    void appendProperties(Map<String, Object> properties) {
        if (properties != null && !properties.isEmpty()) {
            Set<String> keySet = properties.keySet();
            for (String key : keySet) {
                this.appendProperty(key, JsonUtil.createJsonValue(properties.get(key)));
            }
        }
    }

    Object getDetail(String key) {
        return this.details.get(key);
    }

    void appendDetail(String key, Object value) {
        if (this.details.containsKey(key)) {
            throw new IllegalArgumentException("Duplicate detail " + key);
        }
        this.replaceDetail(key, value);
    }

    void replaceDetail(String key, Object value) {
        this.details.put(key, value);
    }

    JsonValue toJson() {
        JsonArray json = new JsonArray();
        json.append(this.action);
        json.append(this.target);
        if (!this.details.isEmpty()) {
            Set<String> keySet = this.details.keySet();
            for (String key : keySet) {
                json.append(JsonUtil.createJsonValue(this.details.get(key)));
            }
        }
        if (!this.properties.isEmpty()) {
            JsonValue jsonObject = JsonUtil.createJsonObject(this.properties);
            json.append(jsonObject);
        }
        return json;
    }
}

