/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;

public class Calendar
implements Serializable,
Cloneable,
Comparable {
    private static final long serialVersionUID = 1L;
    public final java.util.Calendar calendar;
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int YEAR_WOY = 17;
    public static final int DOW_LOCAL = 18;
    public static final int EXTENDED_YEAR = 19;
    public static final int JULIAN_DAY = 20;
    public static final int MILLISECONDS_IN_DAY = 21;
    protected static final int BASE_FIELD_COUNT = 22;
    protected static final int MAX_FIELD_COUNT = 32;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int AM = 0;
    public static final int PM = 1;
    public static final int WEEKDAY = 0;
    public static final int WEEKEND = 1;
    public static final int WEEKEND_ONSET = 2;
    public static final int WEEKEND_CEASE = 3;
    private static ULocale[] availableULocales;

    public Calendar(java.util.Calendar delegate) {
        this.calendar = delegate;
    }

    public static synchronized Calendar getInstance() {
        return new Calendar(java.util.Calendar.getInstance());
    }

    public static synchronized Calendar getInstance(TimeZone zone) {
        return new Calendar(java.util.Calendar.getInstance(zone.timeZone));
    }

    public static synchronized Calendar getInstance(Locale aLocale) {
        return new Calendar(java.util.Calendar.getInstance(aLocale));
    }

    public static synchronized Calendar getInstance(ULocale locale) {
        return new Calendar(java.util.Calendar.getInstance(locale.toLocale()));
    }

    public static synchronized Calendar getInstance(TimeZone zone, Locale aLocale) {
        return new Calendar(java.util.Calendar.getInstance(zone.timeZone, aLocale));
    }

    public static synchronized Calendar getInstance(TimeZone zone, ULocale locale) {
        return new Calendar(java.util.Calendar.getInstance(zone.timeZone, locale.toLocale()));
    }

    public static Locale[] getAvailableLocales() {
        return java.util.Calendar.getAvailableLocales();
    }

    public static ULocale[] getAvailableULocales() {
        if (availableULocales == null) {
            Locale[] locales = java.util.Calendar.getAvailableLocales();
            ULocale[] ulocales = new ULocale[locales.length];
            int i = 0;
            while (i < locales.length) {
                ulocales[i] = ULocale.forLocale(locales[i]);
                ++i;
            }
            availableULocales = ulocales;
        }
        return (ULocale[])availableULocales.clone();
    }

    public final Date getTime() {
        return this.calendar.getTime();
    }

    public final void setTime(Date date) {
        this.calendar.setTime(date);
    }

    public long getTimeInMillis() {
        return this.calendar.getTime().getTime();
    }

    public void setTimeInMillis(long millis) {
        this.calendar.setTime(new Date(millis));
    }

    public final int get(int field) {
        return this.calendar.get(field);
    }

    public final void set(int field, int value) {
        this.calendar.set(field, value);
    }

    public final void set(int year, int month, int date) {
        this.calendar.set(year, month, date);
    }

    public final void set(int year, int month, int date, int hour, int minute) {
        this.calendar.set(year, month, date, hour, minute);
    }

    public final void set(int year, int month, int date, int hour, int minute, int second) {
        this.calendar.set(year, month, date, hour, minute, second);
    }

    public final void clear() {
        this.calendar.clear();
    }

    public final void clear(int field) {
        this.calendar.clear(field);
    }

    public final boolean isSet(int field) {
        return this.calendar.isSet(field);
    }

    public boolean equals(Object obj) {
        try {
            return this.calendar.equals(((Calendar)obj).calendar);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isEquivalentTo(Calendar other) {
        return this.getClass() == other.getClass() && this.isLenient() == other.isLenient() && this.getFirstDayOfWeek() == other.getFirstDayOfWeek() && this.getMinimalDaysInFirstWeek() == other.getMinimalDaysInFirstWeek() && this.getTimeZone().equals(other.getTimeZone());
    }

    public int hashCode() {
        return this.calendar.hashCode();
    }

    private long compare(Object that) {
        long thatMs;
        if (that instanceof Calendar) {
            thatMs = ((Calendar)that).getTimeInMillis();
        } else if (that instanceof Date) {
            thatMs = ((Date)that).getTime();
        } else {
            throw new IllegalArgumentException(that + "is not a Calendar or Date");
        }
        return this.getTimeInMillis() - thatMs;
    }

    public boolean before(Object when) {
        return this.compare(when) < 0L;
    }

    public boolean after(Object when) {
        return this.compare(when) > 0L;
    }

    public int getActualMaximum(int field) {
        return this.calendar.getActualMaximum(field);
    }

    public int getActualMinimum(int field) {
        return this.calendar.getActualMinimum(field);
    }

    public final void roll(int field, boolean up) {
        this.calendar.roll(field, up);
    }

    public void roll(int field, int amount) {
        this.calendar.roll(field, amount);
    }

    public void add(int field, int amount) {
        this.calendar.add(field, amount);
    }

    public String getDisplayName(Locale loc) {
        return "Calendar";
    }

    public String getDisplayName(ULocale loc) {
        return "Calendar";
    }

    public int compareTo(Calendar that) {
        long v = this.getTimeInMillis() - that.getTimeInMillis();
        return v < 0L ? -1 : (v > 0L ? 1 : 0);
    }

    public int compareTo(Object that) {
        return this.compareTo((Calendar)that);
    }

    public DateFormat getDateTimeFormat(int dateStyle, int timeStyle, Locale loc) {
        return Calendar.formatHelper(this, loc, dateStyle, timeStyle);
    }

    public DateFormat getDateTimeFormat(int dateStyle, int timeStyle, ULocale loc) {
        return Calendar.formatHelper(this, loc.toLocale(), dateStyle, timeStyle);
    }

    private static DateFormat formatHelper(Calendar cal, Locale loc, int dateStyle, int timeStyle) {
        DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, loc);
        df.setCalendar(cal);
        return df;
    }

    /*
     * Unable to fully structure code
     */
    public int fieldDifference(Date when, int field) {
        block11: {
            block10: {
                min = 0;
                startMs = this.getTimeInMillis();
                if (startMs >= (targetMs = when.getTime())) break block10;
                max = 1;
                do {
                    this.setTimeInMillis(startMs);
                    this.add(field, max);
                    ms = this.getTimeInMillis();
                    if (ms == targetMs) {
                        return max;
                    }
                    if (ms > targetMs) ** GOTO lbl24
                } while ((max <<= 1) >= 0);
                throw new RuntimeException();
lbl-1000:
                // 1 sources

                {
                    t = (min + max) / 2;
                    this.setTimeInMillis(startMs);
                    this.add(field, t);
                    ms = this.getTimeInMillis();
                    if (ms == targetMs) {
                        return t;
                    }
                    if (ms > targetMs) {
                        max = t;
                        continue;
                    }
                    min = t;
lbl24:
                    // 3 sources

                    ** while (max - min > 1)
                }
lbl25:
                // 1 sources

                break block11;
            }
            if (startMs <= targetMs) break block11;
            max = -1;
            do {
                this.setTimeInMillis(startMs);
                this.add(field, max);
                ms = this.getTimeInMillis();
                if (ms == targetMs) {
                    return max;
                }
                if (ms < targetMs) ** GOTO lbl48
            } while ((max <<= 1) != 0);
            throw new RuntimeException();
lbl-1000:
            // 1 sources

            {
                t = (min + max) / 2;
                this.setTimeInMillis(startMs);
                this.add(field, t);
                ms = this.getTimeInMillis();
                if (ms == targetMs) {
                    return t;
                }
                if (ms < targetMs) {
                    max = t;
                    continue;
                }
                min = t;
lbl48:
                // 3 sources

                ** while (min - max > 1)
            }
        }
        this.setTimeInMillis(startMs);
        this.add(field, min);
        return min;
    }

    public void setTimeZone(TimeZone value) {
        this.calendar.setTimeZone(value.timeZone);
    }

    public TimeZone getTimeZone() {
        return new TimeZone(this.calendar.getTimeZone());
    }

    public void setLenient(boolean lenient) {
        this.calendar.setLenient(lenient);
    }

    public boolean isLenient() {
        return this.calendar.isLenient();
    }

    public void setFirstDayOfWeek(int value) {
        this.calendar.setFirstDayOfWeek(value);
    }

    public int getFirstDayOfWeek() {
        return this.calendar.getFirstDayOfWeek();
    }

    public void setMinimalDaysInFirstWeek(int value) {
        this.calendar.setMinimalDaysInFirstWeek(value);
    }

    public int getMinimalDaysInFirstWeek() {
        return this.calendar.getMinimalDaysInFirstWeek();
    }

    public final int getMinimum(int field) {
        return this.calendar.getMinimum(field);
    }

    public final int getMaximum(int field) {
        return this.calendar.getMaximum(field);
    }

    public final int getGreatestMinimum(int field) {
        return this.calendar.getGreatestMinimum(field);
    }

    public final int getLeastMaximum(int field) {
        return this.calendar.getLeastMaximum(field);
    }

    public int getDayOfWeekType(int dayOfWeek) {
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            throw new IllegalArgumentException("illegal day of week: " + dayOfWeek);
        }
        return dayOfWeek >= 7 ? 1 : 0;
    }

    public int getWeekendTransition(int dayOfWeek) {
        throw new IllegalArgumentException("Not weekend transition day");
    }

    public boolean isWeekend(Date date) {
        this.calendar.setTime(date);
        return this.isWeekend();
    }

    public boolean isWeekend() {
        return this.calendar.get(7) >= 7;
    }

    public Object clone() {
        return new Calendar((java.util.Calendar)this.calendar.clone());
    }

    public String toString() {
        return this.calendar.toString();
    }

    public String getType() {
        return "gregorian";
    }
}

