/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.internal.dnd.DNDAdapter;
import org.eclipse.swt.internal.dnd.IDNDAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    IDNDAdapter dndAdapter;
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DragSourceEffect dragEffect;
    Composite topControl;
    int dataEffect = 0;
    static final String DEFAULT_DRAG_SOURCE_EFFECT = "DEFAULT_DRAG_SOURCE_EFFECT";
    static final int CFSTR_PERFORMEDDROPEFFECT = Transfer.registerType("Performed DropEffect");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DragSource(Control control, int style) {
        super(control, DragSource.checkStyle(style));
        this.control = control;
        if (control.getData("DragSource") != null) {
            DND.error(2000);
        }
        control.setData("DragSource", this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12 && !DragSource.this.isDisposed()) {
                    DragSource.this.dispose();
                }
                if (event.type == 29) {
                    DragSource.this.isDisposed();
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                DragSource.this.onDispose();
            }
        });
        Object effect = control.getData(DEFAULT_DRAG_SOURCE_EFFECT);
        if (effect instanceof DragSourceEffect) {
            this.dragEffect = (DragSourceEffect)effect;
        }
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    public Object getAdapter(Class adapter) {
        Object result;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.dnd.IDNDAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            if (this.dndAdapter == null) {
                this.dndAdapter = new DNDAdapter();
            }
            result = this.dndAdapter;
        } else {
            result = super.getAdapter(adapter);
        }
        return result;
    }

    public void addDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DragSourceEvent.addListener(this, listener);
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    public Control getControl() {
        return this.control;
    }

    public DragSourceListener[] getDragListeners() {
        return (DragSourceListener[])DragSourceEvent.getListeners(this);
    }

    public DragSourceEffect getDragSourceEffect() {
        return this.dragEffect;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    private void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DragSource", null);
        this.control = null;
        this.transferAgents = null;
    }

    public void removeDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DragSourceEvent.removeListener(this, listener);
    }

    public void setDragSourceEffect(DragSourceEffect effect) {
        this.dragEffect = effect;
    }

    public void setTransfer(Transfer[] transferAgents) {
        this.transferAgents = transferAgents;
    }
}

