/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme.css;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.css.ConditionalValue;
import org.eclipse.rwt.internal.theme.css.IStylePropertyMap;
import org.eclipse.rwt.internal.theme.css.SelectorExt;
import org.eclipse.rwt.internal.theme.css.Specific;
import org.eclipse.rwt.internal.theme.css.StyleRule;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

public final class StyleSheet {
    private static final SelectorWrapperComparator COMPARATOR = new SelectorWrapperComparator();
    private final StyleRule[] styleRules;
    private SelectorWrapper[] selectorWrappers;

    public StyleSheet(StyleRule[] styleRules) {
        this.styleRules = (StyleRule[])styleRules.clone();
        this.createSelectorWrappers();
    }

    public StyleRule[] getStyleRules() {
        return (StyleRule[])this.styleRules.clone();
    }

    public ConditionalValue[] getValues(String elementName, String propertyName) {
        ArrayList<ConditionalValue> buffer = new ArrayList<ConditionalValue>();
        int i = 0;
        while (i < this.selectorWrappers.length) {
            QxType value;
            SelectorWrapper selectorWrapper = this.selectorWrappers[i];
            String selectorElement = ((SelectorExt)((Object)selectorWrapper.selector)).getElementName();
            if ((selectorElement == null || selectorElement.equals(elementName)) && (value = selectorWrapper.propertyMap.getValue(propertyName)) != null) {
                Object[] constraints = ((SelectorExt)((Object)selectorWrapper.selector)).getConstraints();
                Arrays.sort(constraints);
                if (!StyleSheet.containsConstraintsAlready(buffer, (String[])constraints)) {
                    buffer.add(new ConditionalValue((String[])constraints, value));
                }
            }
            ++i;
        }
        ConditionalValue[] result = new ConditionalValue[buffer.size()];
        buffer.toArray(result);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        StyleRule[] styleRules = this.getStyleRules();
        int i = 0;
        while (i < styleRules.length) {
            StyleRule styleRule = styleRules[i];
            SelectorList selectors = styleRule.getSelectors();
            int length = selectors.getLength();
            int j = 0;
            while (j < length) {
                if (j > 0) {
                    buffer.append(",");
                }
                if (i > 0) {
                    buffer.append("\n");
                }
                buffer.append(selectors.item(j));
                ++j;
            }
            buffer.append("\n");
            buffer.append(styleRule.getProperties());
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }

    private static boolean containsConstraintsAlready(List conditionalValuesList, String[] constraints) {
        Iterator iterator = conditionalValuesList.iterator();
        boolean result = false;
        while (iterator.hasNext() && !result) {
            ConditionalValue condValue = (ConditionalValue)iterator.next();
            if (!Arrays.equals(condValue.constraints, constraints)) continue;
            result = true;
        }
        return result;
    }

    private void createSelectorWrappers() {
        ArrayList<SelectorWrapper> selectorWrappersList = new ArrayList<SelectorWrapper>();
        int pos = 0;
        while (pos < this.styleRules.length) {
            StyleRule styleRule = this.styleRules[pos];
            SelectorList selectors = styleRule.getSelectors();
            IStylePropertyMap properties = styleRule.getProperties();
            int length = selectors.getLength();
            int i = 0;
            while (i < length) {
                Selector selector = selectors.item(i);
                SelectorWrapper selectorWrapper = new SelectorWrapper(selector, properties, pos);
                selectorWrappersList.add(selectorWrapper);
                ++i;
            }
            ++pos;
        }
        Collections.sort(selectorWrappersList, COMPARATOR);
        Collections.reverse(selectorWrappersList);
        this.selectorWrappers = new SelectorWrapper[selectorWrappersList.size()];
        selectorWrappersList.toArray(this.selectorWrappers);
    }

    static class SelectorWrapper {
        public final Selector selector;
        public final IStylePropertyMap propertyMap;
        public final int position;

        public SelectorWrapper(Selector selector, IStylePropertyMap propertyMap, int position) {
            this.selector = selector;
            this.propertyMap = propertyMap;
            this.position = position;
        }
    }

    private static class SelectorWrapperComparator
    implements Comparator {
        private SelectorWrapperComparator() {
        }

        public int compare(Object object1, Object object2) {
            int specificity2;
            int result = 0;
            SelectorWrapper selectorWrapper1 = (SelectorWrapper)object1;
            SelectorWrapper selectorWrapper2 = (SelectorWrapper)object2;
            int specificity1 = ((Specific)((Object)selectorWrapper1.selector)).getSpecificity();
            if (specificity1 > (specificity2 = ((Specific)((Object)selectorWrapper2.selector)).getSpecificity())) {
                result = 1;
            } else if (specificity1 < specificity2) {
                result = -1;
            } else if (selectorWrapper1.position > selectorWrapper2.position) {
                result = 1;
            } else if (selectorWrapper1.position < selectorWrapper2.position) {
                result = -1;
            }
            return result;
        }
    }
}

