/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.IConfiguration;
import org.eclipse.rwt.internal.IEngineConfig;

public class ConfigurationReader {
    private IConfiguration configuration;
    private IEngineConfig engineConfig;

    public IConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new ConfigurationImpl();
        }
        return this.configuration;
    }

    public IEngineConfig getEngineConfig() {
        return this.engineConfig;
    }

    public void setEngineConfig(IEngineConfig engineConfig) {
        this.engineConfig = engineConfig;
    }

    private static final class ConfigurationImpl
    implements IConfiguration {
        private final Map values = new HashMap();

        private ConfigurationImpl() {
        }

        public String getLifeCycle() {
            String defaultValue = IConfiguration.LIFE_CYCLE_DEFAULT;
            return this.getConfigValue("lifecycle", defaultValue);
        }

        public String getResources() {
            String defaultValue = "deliverFromDisk";
            return this.getConfigValue("resources", defaultValue);
        }

        private String getConfigValue(String tagName, String defaultValue) {
            if (!this.values.containsKey(tagName)) {
                String result = "";
                result = System.getProperty(tagName) != null ? System.getProperty(tagName) : defaultValue;
                this.values.put(tagName, result);
            }
            return (String)this.values.get(tagName);
        }
    }
}

