/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme.css;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rwt.apache.batik.css.parser.ParseException;
import org.eclipse.rwt.internal.theme.ResourceLoader;
import org.eclipse.rwt.internal.theme.ThemeManagerException;
import org.eclipse.rwt.internal.theme.css.ConditionFactoryImpl;
import org.eclipse.rwt.internal.theme.css.DocumentHandlerImpl;
import org.eclipse.rwt.internal.theme.css.SelectorFactoryImpl;
import org.eclipse.rwt.internal.theme.css.StyleSheet;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;

public class CssFileReader {
    private static final String CSS_ENCODING = "UTF-8";
    private final List problems;
    private Parser parser;

    CssFileReader() {
        try {
            this.parser = new org.eclipse.rwt.apache.batik.css.parser.Parser();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate CSS parser", e);
        }
        this.problems = new ArrayList();
    }

    public static StyleSheet readStyleSheet(String fileName, ResourceLoader loader) throws IOException {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        InputStream inputStream = loader.getResourceAsStream(fileName);
        if (inputStream == null) {
            throw new IllegalArgumentException("Could not open resource " + fileName);
        }
        return CssFileReader.parseStyleSheet(inputStream, fileName, loader);
    }

    public static StyleSheet readStyleSheet(InputStream inputStream, String fileName, ResourceLoader loader) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        return CssFileReader.parseStyleSheet(inputStream, fileName, loader);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static StyleSheet parseStyleSheet(InputStream inputStream, String fileName, ResourceLoader loader) throws IOException {
        StyleSheet styleSheet;
        try {
            try {
                CssFileReader reader = new CssFileReader();
                styleSheet = reader.parse(inputStream, fileName, loader);
            }
            catch (CSSException e) {
                throw new ThemeManagerException("Failed parsing CSS file", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            inputStream.close();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        inputStream.close();
        return styleSheet;
    }

    StyleSheet parse(InputStream inputStream, String uri, ResourceLoader loader) throws CSSException, IOException {
        InputSource source = new InputSource();
        source.setByteStream(inputStream);
        source.setEncoding(CSS_ENCODING);
        source.setURI(uri);
        this.parser.setConditionFactory(new ConditionFactoryImpl(this));
        this.parser.setSelectorFactory(new SelectorFactoryImpl(this));
        DocumentHandlerImpl documentHandler = new DocumentHandlerImpl(this, loader);
        this.parser.setDocumentHandler(documentHandler);
        this.parser.setErrorHandler(new ErrorHandlerImpl(this));
        try {
            this.parser.parseStyleSheet(source);
        }
        catch (ParseException e) {
            throw new CSSException(e);
        }
        return documentHandler.getStyleSheet();
    }

    CSSException[] getProblems() {
        CSSException[] result = new CSSException[this.problems.size()];
        this.problems.toArray(result);
        return result;
    }

    void addProblem(CSSException exception) {
        System.err.println(exception);
        this.problems.add(exception);
    }

    private static class ErrorHandlerImpl
    implements ErrorHandler {
        private final List problems;

        public ErrorHandlerImpl(CssFileReader reader) {
            this.problems = reader.problems;
        }

        public void warning(CSSParseException exception) throws CSSException {
            String problem = ErrorHandlerImpl.createProblemDescription("WARNING: ", exception);
            System.err.println(problem);
            this.problems.add(exception);
        }

        public void error(CSSParseException exception) throws CSSException {
            String problem = ErrorHandlerImpl.createProblemDescription("ERROR: ", exception);
            System.err.println(problem);
            this.problems.add(exception);
        }

        public void fatalError(CSSParseException exception) throws CSSException {
            String problem = ErrorHandlerImpl.createProblemDescription("FATAL ERROR: ", exception);
            System.err.println(problem);
            this.problems.add(exception);
            throw exception;
        }

        private static String createProblemDescription(String type, CSSParseException exception) {
            String pattern = "{0}: {1} in {2} at pos [{3}:{4}]";
            Object[] arguments = new Object[]{type, exception.getMessage(), exception.getURI(), String.valueOf(exception.getLineNumber()), String.valueOf(exception.getColumnNumber())};
            return MessageFormat.format(pattern, arguments);
        }
    }
}

