/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import org.eclipse.rwt.internal.theme.StyleSheetBuilder;
import org.eclipse.rwt.internal.theme.ThemeCssValuesMap;
import org.eclipse.rwt.internal.theme.ThemeableWidget;
import org.eclipse.rwt.internal.theme.css.StyleSheet;

public final class Theme {
    private static final String JS_THEME_PREFIX = "org.eclipse.swt.theme.";
    private final String id;
    private final String jsId;
    private final String name;
    private ThemeCssValuesMap valuesMap;
    private StyleSheetBuilder styleSheetBuilder;

    public Theme(String id, String name, StyleSheet styleSheet) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
        this.name = name != null ? name : "Unnamed Theme";
        this.jsId = Theme.createUniqueJsId(id);
        this.valuesMap = null;
        this.styleSheetBuilder = new StyleSheetBuilder();
        if (styleSheet != null) {
            this.styleSheetBuilder.addStyleSheet(styleSheet);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getJsId() {
        return this.jsId;
    }

    public String getName() {
        return this.name;
    }

    public void addStyleSheet(StyleSheet styleSheet) {
        if (this.valuesMap != null) {
            throw new IllegalStateException("Theme is already initialized");
        }
        this.styleSheetBuilder.addStyleSheet(styleSheet);
    }

    public void initialize(ThemeableWidget[] themeableWidgets) {
        if (this.valuesMap != null) {
            throw new IllegalStateException("Theme is already initialized");
        }
        StyleSheet styleSheet = this.styleSheetBuilder.getStyleSheet();
        this.valuesMap = new ThemeCssValuesMap(styleSheet, themeableWidgets);
        this.styleSheetBuilder = null;
    }

    public ThemeCssValuesMap getValuesMap() {
        if (this.valuesMap == null) {
            throw new IllegalStateException("Theme is not initialized");
        }
        return this.valuesMap;
    }

    private static String createUniqueJsId(String id) {
        String result;
        if ("org.eclipse.rap.rwt.theme.Default".equals(id)) {
            result = "org.eclipse.swt.theme.Default";
        } else {
            String hash = Integer.toHexString(id.hashCode());
            result = "org.eclipse.swt.theme.Custom_" + hash;
        }
        return result;
    }
}

