/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tooltipkit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.IToolTipAdapter;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Widget;

public final class ToolTipLCA
extends AbstractWidgetLCA {
    static final String PROP_VISIBLE = "visible";
    static final String PROP_AUTO_HIDE = "autoHide";
    static final String PROP_TEXT = "text";
    static final String PROP_MESSAGE = "message";
    static final String PROP_LOCATION = "location";
    static final String PROP_SELECTION_LISTENER = "selectionListener";
    static /* synthetic */ Class class$0;

    public void preserveValues(Widget widget) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        ToolTip toolTip = (ToolTip)widget;
        adapter.preserve(PROP_VISIBLE, (Object)toolTip.isVisible());
        adapter.preserve(PROP_AUTO_HIDE, (Object)toolTip.getAutoHide());
        adapter.preserve(PROP_TEXT, (Object)toolTip.getText());
        adapter.preserve(PROP_MESSAGE, (Object)toolTip.getMessage());
        adapter.preserve(PROP_LOCATION, (Object)ToolTipLCA.getLocation(toolTip));
        Boolean hasListener = ToolTipLCA.hasSelectionListener(toolTip);
        adapter.preserve(PROP_SELECTION_LISTENER, (Object)hasListener);
        WidgetLCAUtil.preserveBackgroundGradient(widget);
        WidgetLCAUtil.preserveRoundedBorder(widget);
        WidgetLCAUtil.preserveCustomVariant(widget);
    }

    public void readData(Widget widget) {
        ControlLCAUtil.processSelection(widget, null, false);
        ToolTip toolTip = (ToolTip)widget;
        ToolTipLCA.readVisible(toolTip);
    }

    public void renderInitialization(Widget widget) throws IOException {
        ToolTip toolTip = (ToolTip)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)toolTip);
        Object[] args = new Object[]{ToolTipLCA.getImage(toolTip)};
        writer.newWidget("org.eclipse.swt.widgets.ToolTip", args);
        WidgetLCAUtil.writeStyleFlag((Widget)toolTip, 4096, "BAlLOON");
        WidgetLCAUtil.writeStyleFlag((Widget)toolTip, 1, "ICON_ERROR");
        WidgetLCAUtil.writeStyleFlag((Widget)toolTip, 8, "ICON_WARNING");
        WidgetLCAUtil.writeStyleFlag((Widget)toolTip, 2, "ICON_INFORMATION");
    }

    public void renderChanges(Widget widget) throws IOException {
        ToolTip toolTip = (ToolTip)widget;
        WidgetLCAUtil.writeBackgroundGradient(widget);
        WidgetLCAUtil.writeRoundedBorder(widget);
        WidgetLCAUtil.writeCustomVariant(widget);
        ToolTipLCA.writeText(toolTip);
        ToolTipLCA.writeMessage(toolTip);
        ToolTipLCA.writeLocation(toolTip);
        ToolTipLCA.writeAutoHide(toolTip);
        ToolTipLCA.writeSelectionListener(toolTip);
        ToolTipLCA.writeVisible(toolTip);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    private static void readVisible(ToolTip toolTip) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)toolTip, PROP_VISIBLE);
        if (value != null) {
            toolTip.setVisible(new Boolean(value).booleanValue());
        }
    }

    static void writeText(ToolTip toolTip) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)toolTip);
        String text = WidgetLCAUtil.escapeText(toolTip.getText(), false);
        writer.set(PROP_TEXT, PROP_TEXT, text, "");
    }

    static void writeMessage(ToolTip toolTip) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)toolTip);
        String message = WidgetLCAUtil.escapeText(toolTip.getMessage(), false);
        message = WidgetLCAUtil.replaceNewLines(message, "<br/>");
        writer.set(PROP_MESSAGE, PROP_MESSAGE, message, "");
    }

    private static void writeVisible(ToolTip toolTip) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)toolTip);
        Boolean visible = toolTip.isVisible();
        writer.set(PROP_VISIBLE, PROP_VISIBLE, visible, Boolean.FALSE);
    }

    private static void writeLocation(ToolTip toolTip) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)toolTip);
        Point location = ToolTipLCA.getLocation(toolTip);
        if (WidgetLCAUtil.hasChanged((Widget)toolTip, PROP_LOCATION, location)) {
            Object[] args = new Object[]{new Integer(location.x), new Integer(location.y)};
            writer.call("setLocation", args);
        }
    }

    private static void writeAutoHide(ToolTip toolTip) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)toolTip);
        Boolean autoHide = toolTip.getAutoHide();
        writer.set(PROP_AUTO_HIDE, "hideAfterTimeout", autoHide, Boolean.FALSE);
    }

    private static void writeSelectionListener(ToolTip toolTip) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)toolTip);
        Boolean hasListener = ToolTipLCA.hasSelectionListener(toolTip);
        writer.set(PROP_SELECTION_LISTENER, "hasSelectionListener", hasListener, Boolean.FALSE);
    }

    private static Boolean hasSelectionListener(ToolTip toolTip) {
        return SelectionEvent.hasListener((Adaptable)toolTip);
    }

    private static Point getLocation(ToolTip toolTip) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IToolTipAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = toolTip.getAdapter((Class)clazz);
        IToolTipAdapter toolTipAdapter = (IToolTipAdapter)adapter;
        return toolTipAdapter.getLocation();
    }

    static String getImage(ToolTip toolTip) {
        String result = null;
        if ((toolTip.getStyle() & 1) != 0) {
            result = "error";
        }
        if ((toolTip.getStyle() & 8) != 0) {
            result = "warning";
        }
        if ((toolTip.getStyle() & 2) != 0) {
            result = "information";
        }
        return result;
    }
}

