/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import org.eclipse.rwt.internal.theme.IThemeAdapter;
import org.eclipse.rwt.internal.theme.QxBorder;
import org.eclipse.rwt.internal.theme.QxBoxDimensions;
import org.eclipse.rwt.internal.theme.QxColor;
import org.eclipse.rwt.internal.theme.QxDimension;
import org.eclipse.rwt.internal.theme.QxFont;
import org.eclipse.rwt.internal.theme.QxImage;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.rwt.internal.theme.ThemeUtil;
import org.eclipse.rwt.internal.theme.ThemeableWidget;
import org.eclipse.rwt.internal.theme.WidgetMatcher;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractThemeAdapter
implements IThemeAdapter {
    private WidgetMatcher matcher = new WidgetMatcher();

    public AbstractThemeAdapter() {
        this.configureMatcher(this.matcher);
    }

    public static String getPrimaryElement(Widget widget) {
        String result;
        Class<?> widgetClass = widget.getClass();
        ThemeManager manager = ThemeManager.getInstance();
        ThemeableWidget thWidget = manager.getThemeableWidget(widgetClass);
        if (thWidget != null && thWidget.elements != null && thWidget.elements.length > 0) {
            result = thWidget.elements[0].getName();
        } else {
            String className = widgetClass.getName();
            int last = className.lastIndexOf(46);
            result = className.substring(last + 1);
        }
        return result;
    }

    protected abstract void configureMatcher(WidgetMatcher var1);

    protected Color getCssColor(String cssElement, String cssProperty, Widget widget) {
        QxType cssValue = ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
        return QxColor.createColor((QxColor)cssValue);
    }

    protected Font getCssFont(String cssElement, String cssProperty, Widget widget) {
        QxType cssValue = ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
        return QxFont.createFont((QxFont)cssValue);
    }

    protected int getCssBorderWidth(String cssElement, String cssProperty, Widget widget) {
        QxType cssValue = ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
        return ((QxBorder)cssValue).width;
    }

    protected int getCssDimension(String cssElement, String cssProperty, Widget widget) {
        QxType cssValue = ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
        return ((QxDimension)cssValue).value;
    }

    protected Rectangle getCssBoxDimensions(String cssElement, String cssProperty, Widget widget) {
        QxType cssValue = ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
        return QxBoxDimensions.createRectangle((QxBoxDimensions)cssValue);
    }

    protected Point getCssImageDimension(String cssElement, String cssProperty, Widget widget) {
        QxImage image = (QxImage)ThemeUtil.getCssValue(cssElement, cssProperty, this.matcher, widget);
        return new Point(image.width, image.height);
    }
}

