/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance;

import java.util.List;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.PerformanceRegressionTestCase;

public abstract class PerformanceTest
extends PerformanceRegressionTestCase {
    protected boolean shouldUseParameterizedSQL = false;
    protected boolean shouldCache = false;
    protected boolean shouldBatch = false;
    protected boolean shouldUseEmulatedDB = false;
    protected List allObjects;

    public String getName() {
        String name = super.getName();
        if (this.shouldCache) {
            name = name + "Cached";
        }
        if (this.shouldUseParameterizedSQL) {
            name = name + "ParameterizedSQL";
        }
        if (this.shouldBatch) {
            name = name + "Batched";
        }
        if (this.shouldUseEmulatedDB) {
            name = name + "EmulatedDB";
        }
        return name;
    }

    public boolean shouldCache() {
        return this.shouldCache;
    }

    public boolean shouldUseEmulatedDB() {
        return this.shouldUseEmulatedDB;
    }

    public void setShouldUseEmulatedDB(boolean shouldUseEmulatedDB) {
        this.shouldUseEmulatedDB = shouldUseEmulatedDB;
    }

    public boolean shouldBatch() {
        return this.shouldBatch;
    }

    public void setShouldBatch(boolean shouldBatch) {
        this.shouldBatch = shouldBatch;
    }

    public void setShouldCache(boolean shouldCache) {
        this.shouldCache = shouldCache;
    }

    public boolean shouldUseParameterizedSQL() {
        return this.shouldUseParameterizedSQL;
    }

    public void setShouldUseParameterizedSQL(boolean shouldUseParameterizedSQL) {
        this.shouldUseParameterizedSQL = shouldUseParameterizedSQL;
    }

    public void setup() {
        if (this.shouldUseParameterizedSQL()) {
            this.getSession().getLogin().cacheAllStatements();
        }
        if (this.shouldBatch()) {
            this.getSession().getLogin().useBatchWriting();
            if (this.shouldUseParameterizedSQL()) {
                this.getSession().getLogin().setMaxBatchWritingSize(20);
            } else {
                this.getSession().getLogin().setMaxBatchWritingSize(32000);
            }
        }
        if (this.shouldUseEmulatedDB()) {
            this.setupEmulatedDB();
        }
    }

    public void setupEmulatedDB() {
        Session session = this.buildEmulatedSession();
        this.getExecutor().swapSession(session);
    }

    public void test() throws Exception {
        if (!this.shouldCache()) {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        }
    }

    public void reset() {
        if (this.shouldUseParameterizedSQL()) {
            this.getSession().getLogin().dontCacheAllStatements();
        }
        if (this.shouldBatch()) {
            this.getSession().getLogin().dontUseBatchWriting();
        }
        if (this.shouldUseEmulatedDB()) {
            this.getExecutor().resetSession();
        }
    }
}

