/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.isolatedsession;

import junit.framework.Test;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.isolatedsession.CheckAccessorUsageForIsolatedClass;
import org.eclipse.persistence.testing.tests.isolatedsession.ExceptionOnIsolatedReference;
import org.eclipse.persistence.testing.tests.isolatedsession.ExclusiveConnectionClosedExceptionTest;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedOneToManyQueryModificationTest;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedOneToOneQueryModificationTest;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedQueryTest;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedSessionRelationConformingTest;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedSessionSystem;
import org.eclipse.persistence.testing.tests.isolatedsession.NoRowsUpdatedTest;
import org.eclipse.persistence.testing.tests.isolatedsession.ProjectXMLTest;
import org.eclipse.persistence.testing.tests.isolatedsession.VPDSupportTest;
import org.eclipse.persistence.testing.tests.isolatedsession.VerifyExclusiveConnectionTest;
import org.eclipse.persistence.testing.tests.isolatedsession.VerifyIsolationTest;
import org.eclipse.persistence.testing.tests.isolatedsession.VerifyQueryCacheIsolated;

public class IsolatedSessionTestModel
extends TestModel {
    public IsolatedSessionTestModel() {
        this.setDescription("This model tests the Isoalted Session Support and verifies its compatability with other TopLink features.");
    }

    public IsolatedSessionTestModel(boolean isSRG) {
        this();
        this.isSRG = isSRG;
    }

    public void addRequiredSystems() {
        if (!(this.getSession().getPlatform() instanceof OraclePlatform)) {
            throw new TestWarningException("This model is intended for Oracle databases only.");
        }
        this.addRequiredSystem(new IsolatedSessionSystem());
    }

    public void addTests() {
        this.addTest((Test)new VerifyIsolationTest("Transactional"));
        this.addTest((Test)new VerifyIsolationTest("Isolated"));
        this.addTest((Test)new VerifyIsolationTest("Always"));
        this.addTest((Test)new VerifyExclusiveConnectionTest("Always", false));
        this.addTest((Test)new VerifyExclusiveConnectionTest("Always", true));
        this.addTest((Test)new VerifyExclusiveConnectionTest("Isolated", true));
        this.addTest((Test)new ExceptionOnIsolatedReference());
        this.addTest((Test)new VPDSupportTest());
        this.addTest((Test)new IsolatedQueryTest());
        this.addTest((Test)new ExclusiveConnectionClosedExceptionTest());
        this.addTest((Test)new NoRowsUpdatedTest());
        this.addTest((Test)new ProjectXMLTest());
        this.addTest((Test)new VerifyQueryCacheIsolated(false));
        this.addTest((Test)new CheckAccessorUsageForIsolatedClass());
        this.addTest((Test)new IsolatedSessionRelationConformingTest());
        this.addTest((Test)new IsolatedOneToManyQueryModificationTest());
        this.addTest((Test)new IsolatedOneToOneQueryModificationTest());
    }

    public void addSRGTests() {
    }

    public void reset() {
        this.getExecutor().removeConfigureSystem((TestSystem)new IsolatedSessionSystem());
    }
}

