/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionbroker;

import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.sessionbroker.Client;
import org.eclipse.persistence.testing.tests.sessionbroker.Server;

public class ClientBrokerTest
extends AutoVerifyTestCase {
    protected DatabaseLogin login;
    protected Client[] clients = new Client[3];
    protected Server server;

    public ClientBrokerTest() {
        this.setDescription("The test simulates the session broker by spawning clients in the thread");
    }

    public void reset() {
        this.clients[0].release();
        this.clients[1].release();
        this.clients[2].release();
        this.server.logout();
        ((DatabaseSession)this.getSession()).logout();
        ((DatabaseSession)this.getSession()).login();
    }

    public void setup() {
        this.server = new Server();
        this.server.sSessionBroker.setLogLevel(this.getSession().getLogLevel());
        this.server.sSessionBroker.setLog(this.getSession().getLog());
        this.server.login();
        this.clients[0] = new Client(this.server, "Smith", this.getSession());
        this.clients[1] = new Client(this.server, "Way", this.getSession());
        this.clients[2] = new Client(this.server, "Chanley", this.getSession());
    }

    public void test() {
        this.clients[0].start();
        this.clients[1].start();
        this.clients[2].start();
        try {
            this.clients[0].join();
            this.clients[1].join();
            this.clients[2].join();
        }
        catch (InterruptedException exception) {
            TestErrorException testException = new TestErrorException("Client threads are interrupted");
            testException.setInternalException((Throwable)exception);
            throw testException;
        }
    }
}

