/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.helper;

import junit.framework.TestCase;
import org.eclipse.persistence.internal.helper.JavaSEPlatform;
import org.eclipse.persistence.internal.helper.JavaVersion;
import org.eclipse.persistence.testing.framework.ReflectionHelper;
import org.junit.Test;

public class JavaUtilTest
extends TestCase {
    static final int[][] VALID = new int[][]{{1, 1}, {1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 9}, {9, 0}, {10, 0}, {18, 3}, {18, 9}};
    static final int[][] INVALID = new int[][]{{0, 0}, {0, 1}, {0, 3}, {0, 5}, {0, 7}, {0, 9}, {1, 0}, {2, 0}, {2, 1}, {2, 2}, {3, 0}, {4, 0}, {1, 10}, {18, 1}, {18, 2}, {18, 4}, {18, 5}, {18, 6}, {18, 7}, {18, 8}, {18, 10}, {18, 11}, {18, 12}};
    static final JavaSEPlatform LATEST = JavaUtilTest.initDefault();

    static int[] resultMapping(int[] version) {
        switch (version[0]) {
            case 1: {
                switch (version[1]) {
                    case 9: {
                        return new int[]{9, 0};
                    }
                }
                return version;
            }
        }
        return version;
    }

    private static final JavaSEPlatform initDefault() {
        try {
            return (JavaSEPlatform)ReflectionHelper.getPrivateStatic(JavaSEPlatform.class, (String)"LATEST");
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    public JavaUtilTest(String name) {
        super(name);
    }

    @Test
    public void testJavaVersionCompareTo() {
        JavaVersion version = new JavaVersion(1, 4);
        JavaUtilTest.assertEquals((int)1, (int)version.comapreTo(new JavaVersion(0, 4)));
        JavaUtilTest.assertEquals((int)-1, (int)version.comapreTo(new JavaVersion(2, 4)));
        JavaUtilTest.assertEquals((int)1, (int)version.comapreTo(new JavaVersion(1, 3)));
        JavaUtilTest.assertEquals((int)-1, (int)version.comapreTo(new JavaVersion(1, 5)));
        JavaUtilTest.assertEquals((int)0, (int)version.comapreTo(new JavaVersion(1, 4)));
    }

    @Test
    public void testJavaVersion() {
        JavaVersion version = JavaVersion.vmVersion();
        JavaUtilTest.assertTrue((version.getMajor() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStringToPlatform() {
        JavaSEPlatform platform;
        String versionString;
        int minor;
        int major;
        for (int[] version : VALID) {
            major = version[0];
            minor = version[1];
            versionString = JavaSEPlatform.versionString((int)major, (int)minor);
            platform = JavaSEPlatform.toValue((String)versionString);
            JavaUtilTest.assertNotNull((String)("There should exist platform for valid platform version number [" + Integer.toString(major) + "," + Integer.toString(minor) + "]"), (Object)platform);
            int[] result = JavaUtilTest.resultMapping(version);
            JavaUtilTest.assertTrue((String)("Returned platform version numbers do not match provided version number [" + Integer.toString(major) + "," + Integer.toString(minor) + "]"), (result[0] == platform.getMajor() && result[1] == platform.getMinor() ? 1 : 0) != 0);
        }
        for (int[] version : INVALID) {
            major = version[0];
            minor = version[1];
            versionString = JavaSEPlatform.versionString((int)major, (int)minor);
            platform = JavaSEPlatform.toValue((int)major, (int)minor);
            JavaUtilTest.assertTrue((String)("Returned platform shall be JavaSEPlatform.DEFAULT for invalid version number [" + Integer.toString(major) + "," + Integer.toString(minor) + "]"), (LATEST.getMajor() == platform.getMajor() && LATEST.getMinor() == platform.getMinor() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMajorMinorToPlatform() {
        JavaSEPlatform platform;
        int minor;
        int major;
        for (int[] version : VALID) {
            major = version[0];
            minor = version[1];
            platform = JavaSEPlatform.toValue((int)major, (int)minor);
            JavaUtilTest.assertNotNull((String)("There should exist platform for valid platform version number [" + Integer.toString(major) + "," + Integer.toString(minor) + "]"), (Object)platform);
            int[] result = JavaUtilTest.resultMapping(version);
            JavaUtilTest.assertTrue((String)("Returned platform version numbers do not match provided version number [" + Integer.toString(major) + "," + Integer.toString(minor) + "]"), (result[0] == platform.getMajor() && result[1] == platform.getMinor() ? 1 : 0) != 0);
        }
        for (int[] version : INVALID) {
            major = version[0];
            minor = version[1];
            platform = JavaSEPlatform.toValue((int)major, (int)minor);
            JavaUtilTest.assertTrue((String)("Returned platform shall be JavaSEPlatform.DEFAULT for invalid version number [" + Integer.toString(major) + "," + Integer.toString(minor) + "]"), (LATEST.getMajor() == platform.getMajor() && LATEST.getMinor() == platform.getMinor() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCurrentIs() {
        JavaSEPlatform current = JavaSEPlatform.toValue((int)JavaSEPlatform.CURRENT.getMajor(), (int)JavaSEPlatform.CURRENT.getMinor());
        boolean result = JavaSEPlatform.is((JavaSEPlatform)current);
        JavaUtilTest.assertTrue((String)"Current platform check shall return true.", (boolean)result);
        for (JavaSEPlatform platform : JavaSEPlatform.values()) {
            if (platform.isSupported()) break;
            result = JavaSEPlatform.is((JavaSEPlatform)platform);
            JavaUtilTest.assertFalse((String)"Unsupported platform check shall return false.", (boolean)result);
        }
    }
}

