/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.aggregate;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.testing.models.aggregate.Bicycle;
import org.eclipse.persistence.testing.models.aggregate.Car;
import org.eclipse.persistence.testing.models.aggregate.Customer;
import org.eclipse.persistence.testing.models.aggregate.Dependant;
import org.eclipse.persistence.testing.models.aggregate.House;
import org.eclipse.persistence.testing.models.aggregate.SellingPoint;
import org.eclipse.persistence.testing.models.aggregate.SingleHouse;
import org.eclipse.persistence.testing.models.aggregate.TownHouse;
import org.eclipse.persistence.testing.models.aggregate.Vehicle;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Builder
implements Serializable {
    private String firstName;
    private String lastName;
    private BigDecimal id;
    private List houses = new ArrayList(2);
    private List customers = new ArrayList(2);
    private List vehicles = new ArrayList(2);

    public void addCustomer(Customer customer) {
        this.getCustomers().add(customer);
    }

    public void addHouse(House house) {
        this.getHouses().add(house);
    }

    public void addVehicle(Vehicle vehicle) {
        this.getVehicles().add(vehicle);
    }

    public static Builder example1() {
        Builder example1 = new Builder();
        example1.setFirstName("Micheal");
        example1.setLastName("Jordan");
        example1.addCustomer(Customer.example1());
        example1.addCustomer(Customer.example2());
        example1.addHouse(SingleHouse.example1());
        example1.addHouse(TownHouse.example3());
        example1.addVehicle(Car.example1());
        example1.addVehicle(Car.example2());
        example1.addVehicle(Car.example3());
        example1.addVehicle(Bicycle.example1());
        example1.addVehicle(Bicycle.example2());
        return example1;
    }

    public List getCustomers() {
        return this.customers;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public List getHouses() {
        return this.houses;
    }

    public BigDecimal getId() {
        return this.id;
    }

    public String getLastName() {
        return this.lastName;
    }

    public List getVehicles() {
        return this.vehicles;
    }

    public void removeCustomer(Customer customer) {
        this.getCustomers().remove(customer);
    }

    public void removeHouse(House house) {
        this.getHouses().remove(house);
    }

    public void removeVehicle(Vehicle vehicle) {
        this.getVehicles().remove(vehicle);
    }

    public void setCustomers(List customers) {
        this.customers = customers;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setHouses(List houses) {
        this.houses = houses;
    }

    public void setId(BigDecimal id) {
        this.id = id;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setVehicles(List vehicles) {
        this.vehicles = vehicles;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("BUILDER");
        definition.addIdentityField("BUILDER_ID", BigDecimal.class, 15);
        definition.addField("FNAME", String.class, 30);
        definition.addField("LNAME", String.class, 30);
        definition.addField("VERSION", BigDecimal.class, 15);
        return definition;
    }

    public static TableDefinition houseTableDefinition() {
        TableDefinition definition = House.tableDefinition();
        definition.setName("BUILDER_HOUSE");
        for (int i = 0; i < definition.getFields().size(); ++i) {
            FieldDefinition field = (FieldDefinition)definition.getFields().get(i);
            if (!field.getName().equals("AGENT_ID")) continue;
            field.setName("BUILDER_ID");
            break;
        }
        return definition;
    }

    public static TableDefinition singleHouseTableDefinition() {
        TableDefinition definition = SingleHouse.tableDefinition();
        definition.setName("BUILDER_SINGLE_HOUSE");
        for (int i = 0; i < definition.getFields().size(); ++i) {
            FieldDefinition field = (FieldDefinition)definition.getFields().get(i);
            if (!field.getName().equals("AGENT_ID")) continue;
            field.setName("BUILDER_ID");
            break;
        }
        return definition;
    }

    public static TableDefinition sellingPointTableDefinition() {
        TableDefinition definition = SellingPoint.tableDefinition();
        definition.setName("BUILDER_SELLING_POINT");
        for (int i = 0; i < definition.getFields().size(); ++i) {
            FieldDefinition field = (FieldDefinition)definition.getFields().get(i);
            if (!field.getName().equals("AGENT_ID")) continue;
            field.setName("BUILDER_ID");
            break;
        }
        return definition;
    }

    public static TableDefinition customerTableDefinition() {
        TableDefinition definition = Customer.tableDefinition();
        definition.setName("BUILDER_CUSTOMER");
        for (int i = 0; i < definition.getFields().size(); ++i) {
            FieldDefinition field = (FieldDefinition)definition.getFields().get(i);
            if (!field.getName().equals("AGENT_ID")) continue;
            field.setName("BUILDER_ID");
            break;
        }
        return definition;
    }

    public static TableDefinition dependantTableDefinition() {
        TableDefinition definition = Dependant.tableDefinition();
        definition.setName("BUILDER_DEPENDANT");
        return definition;
    }

    public static TableDefinition vehicleTableDefinition() {
        TableDefinition definition = Vehicle.tableDefinition();
        definition.setName("BUILDER_VEHICLE");
        for (int i = 0; i < definition.getFields().size(); ++i) {
            FieldDefinition field = (FieldDefinition)definition.getFields().get(i);
            if (!field.getName().equals("ID")) continue;
            field.setName("BUILDER_ID");
            field.setIsPrimaryKey(false);
            break;
        }
        return definition;
    }
}

