/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.adapters.aq;

import java.security.AccessController;
import java.sql.DriverManager;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.sql.DataSource;
import oracle.AQ.AQDriverManager;
import oracle.AQ.AQSession;
import org.eclipse.persistence.internal.eis.adapters.aq.AQAdapterMetaData;
import org.eclipse.persistence.internal.eis.adapters.aq.AQConnection;
import org.eclipse.persistence.internal.eis.adapters.aq.AQConnectionSpec;
import org.eclipse.persistence.internal.eis.adapters.aq.AQRecordFactory;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;

public class AQConnectionFactory
implements ConnectionFactory {
    public Connection getConnection() throws ResourceException {
        return this.getConnection(new AQConnectionSpec());
    }

    public Connection getConnection(ConnectionSpec spec) throws ResourceException {
        AQSession session;
        java.sql.Connection connection;
        AQConnectionSpec aqSpec;
        try {
            aqSpec = (AQConnectionSpec)spec;
            if (aqSpec.hasDatasource()) {
                DataSource datasource = (DataSource)new InitialContext().lookup(aqSpec.getDatasource());
                connection = datasource.getConnection();
            } else {
                connection = DriverManager.getConnection(aqSpec.getURL(), aqSpec.getUser(), aqSpec.getPassword());
                connection.setAutoCommit(false);
            }
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                AccessController.doPrivileged(new PrivilegedClassForName("oracle.AQ.AQOracleDriver", true, this.getClass().getClassLoader()));
            } else {
                PrivilegedAccessHelper.getClassForName((String)"oracle.AQ.AQOracleDriver", (boolean)true, (ClassLoader)this.getClass().getClassLoader());
            }
            session = AQDriverManager.createAQSession((Object)connection);
        }
        catch (Exception exception) {
            throw new ResourceException(exception.toString());
        }
        return new AQConnection(session, connection, aqSpec);
    }

    public ResourceAdapterMetaData getMetaData() {
        return new AQAdapterMetaData();
    }

    public RecordFactory getRecordFactory() {
        return new AQRecordFactory();
    }

    public Reference getReference() {
        return new Reference(this.getClass().getName());
    }

    public void setReference(Reference reference) {
    }
}

