/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.pool;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

public class NamedConnectionPoolCreationDialog
extends AbstractValidatingDialog {
    private JTextField nameTextField;
    private final Collection poolNames;
    private final PropertyValueModel stringHolder;

    public NamedConnectionPoolCreationDialog(WorkbenchContext context, PropertyValueModel stringHolder, Iterator poolNames) {
        super(context);
        this.stringHolder = stringHolder;
        this.poolNames = CollectionTools.collection((Iterator)poolNames);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.getOKAction().setEnabled(false);
    }

    private Document buildNameDocumentAdapter() {
        return new DocumentAdapter(this.stringHolder, new RegexpDocument(13));
    }

    @Override
    protected Component buildMainPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.setTitle(this.resourceRepository().getString("NAMED_CONNECTION_POOL_CREATION_DIALOG_TITLE"));
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel nameLabel = new JLabel(this.resourceRepository().getString("POOL_NAME_LABEL"));
        nameLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("POOL_NAME_LABEL"));
        nameLabel.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("POOL_NAME_LABEL"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)nameLabel, constraints);
        this.nameTextField = new JTextField(this.buildNameDocumentAdapter(), null, 20);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this.nameTextField, constraints);
        nameLabel.setLabelFor(this.nameTextField);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NamedConnectionPoolCreationDialog.this.updateOKAction();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NamedConnectionPoolCreationDialog.this.updateOKAction();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.helpManager().addTopicID(panel, this.helpTopicId() + ".name");
        return panel;
    }

    private void updateOKAction() {
        String poolName = this.nameTextField.getText().trim();
        boolean valid = poolName.length() > 0 && !this.poolNames.contains(poolName);
        this.getOKAction().setEnabled(valid);
        if (valid) {
            this.clearErrorMessage();
        } else {
            this.setErrorMessageKey("NAMED_CONNECTION_POOL_CREATION_DIALOG_INVALID_NAME");
        }
    }

    private String buildUniquePoolName() {
        String poolName = this.preferences().get("new name.pool", this.resourceRepository().getString("POOL_CREATION_DIALOG_NEW_POOL_NAME"));
        return NameTools.uniqueNameFor((String)poolName, (Collection)this.poolNames);
    }

    @Override
    protected String helpTopicId() {
        return "dialog.namedConnectionPoolCreation";
    }

    @Override
    protected void prepareToShow() {
        super.prepareToShow();
        this.nameTextField.setText(this.buildUniquePoolName());
        this.nameTextField.selectAll();
    }

    @Override
    protected Component initialFocusComponent() {
        return this.nameTextField;
    }
}

