/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.internal.sessions.factories.model.transport.JMSTopicTransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.TransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.naming.JNDINamingServiceConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.JNDINamingService;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.JNDINamingServiceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.PropertyAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TransportManagerAdapter;

public final class JMSTopicTransportManagerAdapter
extends TransportManagerAdapter
implements JNDINamingService {
    public static final String JNDI_NAMING_SERVICE_PROPERTY = "jndiNamingService";
    private volatile JNDINamingServiceAdapter namingService;
    public static final String TOPIC_HOST_URL_PROPERTY = "topicHostURL";
    public static final String TOPIC_CONNECTION_FACTORY_NAME_PROPERTY = "topicConnectionFactoryName";
    public static final String TOPIC_NAME_PROPERTY = "topicName";
    public static final String JNDI_ENCRYPTION_CLASS_PROPERTY = "encryptionClass";
    public static final String JNDI_PROPERTIES_COLLECTION = "properties";

    JMSTopicTransportManagerAdapter(SCAdapter parent, JMSTopicTransportManagerConfig scConfig) {
        super(parent, (TransportManagerConfig)scConfig);
    }

    protected JMSTopicTransportManagerAdapter(SCAdapter parent) {
        super(parent);
    }

    private final JMSTopicTransportManagerConfig manager() {
        return (JMSTopicTransportManagerConfig)this.getModel();
    }

    @Override
    protected Object buildModel() {
        return new JMSTopicTransportManagerConfig();
    }

    @Override
    protected void initializeFromModel(Object scConfig) {
        super.initializeFromModel(scConfig);
        this.namingService = (JNDINamingServiceAdapter)this.adapt(this.manager().getJNDINamingServiceConfig());
    }

    @Override
    protected void initializeDefaults() {
        super.initializeDefaults();
        this.setTopicConnectionFactoryName("jms/TopLinkTopicConnectionFactory");
        this.setTopicName("jms/TopLinkTopic");
    }

    @Override
    protected void initialize(Object newConfig) {
        super.initialize(newConfig);
        this.setJNDINamingService(this.buildJNDINamingService());
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.namingService);
    }

    public String getTopicHostURL() {
        return this.manager().getTopicHostURL();
    }

    public void setTopicHostURL(String host) {
        String old = this.manager().getTopicHostURL();
        this.manager().setTopicHostURL(host);
        this.firePropertyChanged(TOPIC_HOST_URL_PROPERTY, old, host);
    }

    public String getTopicConnectionFactoryName() {
        return this.manager().getTopicConnectionFactoryName();
    }

    public void setTopicConnectionFactoryName(String name) {
        String old = this.manager().getTopicConnectionFactoryName();
        this.manager().setTopicConnectionFactoryName(name);
        this.firePropertyChanged(TOPIC_CONNECTION_FACTORY_NAME_PROPERTY, old, name);
    }

    public String getTopicName() {
        return this.manager().getTopicName();
    }

    public void setTopicName(String name) {
        String old = this.manager().getTopicName();
        this.manager().setTopicName(name);
        this.firePropertyChanged(TOPIC_NAME_PROPERTY, old, name);
    }

    private void setJNDINamingService(JNDINamingServiceAdapter service) {
        JNDINamingServiceAdapter old = this.namingService;
        this.namingService = service;
        this.manager().setJNDINamingServiceConfig((JNDINamingServiceConfig)service.getModel());
        this.firePropertyChanged(JNDI_NAMING_SERVICE_PROPERTY, old, service);
    }

    @Override
    public String getURL() {
        return this.namingService.getURL();
    }

    @Override
    public void setURL(String url) {
        this.namingService.setURL(url);
    }

    @Override
    public String getUserName() {
        return this.namingService.getUserName();
    }

    @Override
    public void setUserName(String name) {
        String old = this.namingService.getUserName();
        this.namingService.setUserName(name);
        this.firePropertyChanged("username", old, name);
    }

    @Override
    public String getPassword() {
        return this.namingService.getPassword();
    }

    @Override
    public void setPassword(String pw) {
        String old = this.namingService.getPassword();
        this.namingService.setPassword(pw);
        this.firePropertyChanged("password", old, pw);
    }

    public String getEncryptionClass() {
        return this.namingService.getEncryptionClass();
    }

    public void setEncryptionClass(String name) {
        String old = this.namingService.getEncryptionClass();
        this.namingService.setEncryptionClass(name);
        this.firePropertyChanged(JNDI_ENCRYPTION_CLASS_PROPERTY, old, name);
    }

    @Override
    public String getInitialContextFactoryName() {
        return this.namingService.getInitialContextFactoryName();
    }

    @Override
    public void setInitialContextFactoryName(String name) {
        String old = this.namingService.getInitialContextFactoryName();
        this.namingService.setInitialContextFactoryName(name);
        this.firePropertyChanged("initialContextFactoryName", old, name);
    }

    @Override
    public Iterator properties() {
        return this.namingService.properties();
    }

    @Override
    public int propertySize() {
        return this.namingService.propertySize();
    }

    @Override
    public PropertyAdapter addProperty(String name, String value) {
        PropertyAdapter property = this.namingService.addProperty(name, value);
        this.fireItemAdded("property", (Object)property);
        return property;
    }

    @Override
    public void removeProperty(PropertyAdapter property) {
        this.namingService.removeProperty(property);
        this.fireItemRemoved("property", (Object)property);
    }
}

