/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOption;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.RelationalQueryComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ReportQueryAdvancedOptionsDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;

final class ReportQueryOptionsPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;

    ReportQueryOptionsPanel(PropertyValueModel queryHolder, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.initialize(queryHolder);
        this.initializeLayout();
    }

    private void initialize(PropertyValueModel queryHolder) {
        this.queryHolder = this.buildReportQueryHolder(queryHolder);
    }

    private PropertyValueModel buildReportQueryHolder(PropertyValueModel queryHolder) {
        return new FilteringPropertyValueModel(queryHolder){

            @Override
            protected boolean accept(Object value) {
                return value instanceof MWReportQuery;
            }
        };
    }

    protected String helpTopicId() {
        return "descriptor.queries.options";
    }

    protected void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel returnChoiceLabel = this.buildLabel("RETURN_CHOICE_LABEL");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)returnChoiceLabel, constraints);
        JComboBox returnChoiceComboBox = this.buildReturnChoiceComboBox();
        this.addHelpTopicId(returnChoiceComboBox, this.helpTopicId() + ".returnChoice");
        returnChoiceLabel.setLabelFor(returnChoiceComboBox);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        this.add((Component)returnChoiceComboBox, constraints);
        JLabel retrievePrimaryKeysLabel = this.buildLabel("RETRIEVE_PRIMARY_KEYS_LABEL");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)retrievePrimaryKeysLabel, constraints);
        JComboBox retrievePrimaryKeysComboBox = this.buildRetrievePrimaryKeysComboBox();
        this.addHelpTopicId(retrievePrimaryKeysComboBox, this.helpTopicId() + ".retrievePrimaryKeys");
        retrievePrimaryKeysLabel.setLabelFor(retrievePrimaryKeysComboBox);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        this.add((Component)retrievePrimaryKeysComboBox, constraints);
        JLabel cacheStatementLabel = this.buildLabel("CACHE_STATMENT_LABEL");
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)cacheStatementLabel, constraints);
        JComboBox cacheStatementComboBox = this.buildCacheStatementComboBox();
        this.addHelpTopicId(cacheStatementComboBox, this.helpTopicId() + ".cacheStatement");
        cacheStatementLabel.setLabelFor(cacheStatementComboBox);
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        this.add((Component)cacheStatementComboBox, constraints);
        JLabel bindParametersLabel = this.buildLabel("BIND_PARAMETERS_LABEL");
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)bindParametersLabel, constraints);
        JComboBox bindParametersTriStateComboBox = this.buildBindParametersComboBox();
        this.addHelpTopicId(bindParametersTriStateComboBox, this.helpTopicId() + ".bind");
        bindParametersLabel.setLabelFor(bindParametersTriStateComboBox);
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        this.add((Component)bindParametersTriStateComboBox, constraints);
        JButton advancedOptionsButton = this.buildAdvancedOptionsButton();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(10, 5, 5, 5);
        this.add((Component)advancedOptionsButton, constraints);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private JComboBox buildReturnChoiceComboBox() {
        JComboBox comboBox = new JComboBox(new ComboBoxModelAdapter(this.buildReturnChoiceValueModel(), this.buildReturnChoicePropertyAdapter()));
        comboBox.setRenderer(this.buildTopLinkOptionModelRenderer());
        return comboBox;
    }

    private ListCellRenderer buildTopLinkOptionModelRenderer() {
        return new SimpleListCellRenderer(){

            @Override
            protected String buildText(Object value) {
                return value == null ? "" : ReportQueryOptionsPanel.this.resourceRepository().getString(((TopLinkOption)value).resourceKey());
            }
        };
    }

    private ListValueModel buildReturnChoiceValueModel() {
        return new AbstractReadOnlyListValueModel(){

            @Override
            public Object getValue() {
                return MWReportQuery.returnChoiceOptions().toplinkOptions();
            }
        };
    }

    private PropertyValueModel buildReturnChoicePropertyAdapter() {
        return new PropertyAspectAdapter(this.queryHolder, "returnChoice"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWReportQuery)this.subject).getReturnChoice();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWReportQuery)this.subject).setReturnChoice((MWReportQuery.ReturnChoiceOption)value);
            }
        };
    }

    private JComboBox buildRetrievePrimaryKeysComboBox() {
        JComboBox comboBox = new JComboBox(new ComboBoxModelAdapter(this.buildRetrievePrimaryKeysValueModel(), this.buildRetrievePrimaryKeysPropertyAdapter()));
        comboBox.setRenderer(this.buildTopLinkOptionModelRenderer());
        return comboBox;
    }

    private ListValueModel buildRetrievePrimaryKeysValueModel() {
        return new AbstractReadOnlyListValueModel(){

            @Override
            public Object getValue() {
                return MWReportQuery.retrievePrimaryKeysOptions().toplinkOptions();
            }
        };
    }

    private PropertyValueModel buildRetrievePrimaryKeysPropertyAdapter() {
        return new PropertyAspectAdapter(this.queryHolder, "retrievePrimaryKeys"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWReportQuery)this.subject).getRetrievePrimaryKeys();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWReportQuery)this.subject).setRetrievePrimaryKeys((MWReportQuery.RetrievePrimaryKeysOption)value);
            }
        };
    }

    private JComboBox buildCacheStatementComboBox() {
        return RelationalQueryComponentFactory.buildCacheStatementComboBox(this.queryHolder, this.resourceRepository());
    }

    private JComboBox buildBindParametersComboBox() {
        return RelationalQueryComponentFactory.buildBindParametersComboBox(this.queryHolder, this.resourceRepository());
    }

    private JButton buildAdvancedOptionsButton() {
        JButton button = this.buildButton("ADVANCED_BUTTON_TEXT");
        button.addActionListener(this.buildAdvancedOptionsAction());
        return button;
    }

    private ActionListener buildAdvancedOptionsAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ReportQueryOptionsPanel.this.showAdvancedOptionsDialog();
            }
        };
    }

    private void showAdvancedOptionsDialog() {
        ReportQueryAdvancedOptionsDialog dialog = new ReportQueryAdvancedOptionsDialog(this.getQuery(), this.getWorkbenchContext());
        dialog.show();
        if (dialog.wasConfirmed()) {
            MWReportQuery query = this.getQuery();
            query.setLocking(dialog.getLocking());
            query.setPrepare(dialog.getPrepare());
            query.setCacheQueryResults(dialog.getCacheQueryResults());
            query.setDistinctState(dialog.getDistinctState());
            query.setQueryTimeout(dialog.getQueryTimeout());
            query.setMaximumRows(dialog.getMaximumRows());
            query.setFirstResult(dialog.getFirstResult());
            query.setExclusiveConnection(dialog.getExclusiveConnection());
        }
    }

    private MWReportQuery getQuery() {
        return (MWReportQuery)this.queryHolder.getValue();
    }
}

