/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.DoubleClickMouseListener;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgument;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTree;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTreeModel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTreeNode;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

final class QueryableEditDialog
extends AbstractDialog {
    private QueryableTree queryKeyTree;
    private MWQueryableArgument argument;

    QueryableEditDialog(MWQueryableArgument argument, WorkbenchContext context) {
        super(context, (Dialog)context.getCurrentWindow());
        this.argument = argument;
    }

    @Override
    protected String helpTopicId() {
        return "dialogEditQueryable";
    }

    private TreeSelectionListener buildTreeSelectionHandler() {
        return new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                QueryableEditDialog.this.updateOKButton();
            }
        };
    }

    private MWMappingDescriptor getDescriptor() {
        return this.argument.getParentQuery().getOwningDescriptor();
    }

    @Override
    protected Component buildMainPanel() {
        this.getOKAction().setEnabled(false);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.setTitle(this.resourceRepository().getString("CHOOSE_QUERY_KEY_DIALOG_TITLE.title"));
        this.queryKeyTree = new QueryableTree(new QueryableTreeModel(new DefaultMutableTreeNode(this.getDescriptor()), this.buildQueryableFilter()), this.getWorkbenchContext());
        JScrollPane scrollPane = new JScrollPane(this.queryKeyTree);
        scrollPane.setPreferredSize(new Dimension(250, 200));
        this.queryKeyTree.addTreeSelectionListener(this.buildTreeSelectionHandler());
        this.queryKeyTree.setSelectedQueryableArgumentElement(this.argument.getQueryableArgumentElement());
        SwingComponentFactory.addDoubleClickMouseListener(this.queryKeyTree, new DoubleClickMouseListener(){

            @Override
            public void mouseDoubleClicked(MouseEvent e) {
                TreePath path = QueryableEditDialog.this.queryKeyTree.getPathForLocation(e.getX(), e.getY());
                if (path != null) {
                    QueryableEditDialog.this.clickOK();
                }
            }
        });
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)scrollPane, constraints);
        return panel;
    }

    private Filter buildQueryableFilter() {
        return new Filter(){

            public boolean accept(Object o) {
                return ((MWQueryable)o).isTraversableForQueryExpression();
            }
        };
    }

    @Override
    protected boolean preConfirm() {
        TreePath selectionPath = this.queryKeyTree.getSelectionPath();
        ArrayList<MWQueryable> queryablePath = new ArrayList<MWQueryable>();
        ArrayList<Boolean> allowsNull = new ArrayList<Boolean>();
        QueryableTreeNode selectedNode = (QueryableTreeNode)selectionPath.getLastPathComponent();
        allowsNull.add(selectedNode.isAllowsNull());
        MWQueryable queryableObject = selectedNode.getQueryable();
        queryablePath.add(queryableObject);
        selectionPath = selectionPath.getParentPath();
        while (selectionPath.getPathCount() > 1) {
            selectedNode = (QueryableTreeNode)selectionPath.getLastPathComponent();
            allowsNull.add(new Boolean(selectedNode.isAllowsNull()));
            MWQueryable joinedQueryable = selectedNode.getQueryable();
            queryablePath.add(joinedQueryable);
            selectionPath = selectionPath.getParentPath();
        }
        this.argument.setQueryableArgument(queryablePath.iterator(), allowsNull.iterator());
        ((DefaultMutableTreeNode)this.queryKeyTree.getModel().getRoot()).removeAllChildren();
        return super.preConfirm();
    }

    @Override
    protected void cancelPressed() {
        ((DefaultMutableTreeNode)this.queryKeyTree.getModel().getRoot()).removeAllChildren();
        super.cancelPressed();
    }

    private void updateOKButton() {
        this.getOKAction().setEnabled(this.queryKeyTree.getSelectionCount() > 0);
    }
}

