/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta;

import javax.swing.JLabel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassDescriptionClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.CombinedClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.CombinedClassDescriptionRepositoryFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.BidiTransformer;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.filters.ANDFilter;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

public class ClassChooserTools {
    public static MWClass promptForType(MWClassRepository repository, Filter classNameFilter, WorkbenchContext context) {
        CombinedClassDescriptionRepository cdr = new CombinedClassDescriptionRepository(repository, classNameFilter);
        ClassDescriptionAdapter cda = ClassDescriptionClassDescriptionAdapter.instance();
        String typeName = ClassChooserTools.promptForType(cdr, cda, context);
        if (typeName == null) {
            return null;
        }
        return repository.typeNamed(typeName);
    }

    public static String promptForType(ClassDescriptionRepository classDescriptionRepository, ClassDescriptionAdapter classDescriptionAdapter, WorkbenchContext context) {
        ClassChooserDialog dialog = ClassChooserDialog.createDialog(classDescriptionRepository, classDescriptionAdapter, context);
        dialog.show();
        if (dialog.wasCanceled()) {
            dialog = null;
            ClassChooserDialog.gc();
            return null;
        }
        Object selection = dialog.selection();
        dialog = null;
        ClassChooserDialog.gc();
        return selection == null ? null : classDescriptionAdapter.className(selection);
    }

    public static ClassChooserPanel buildPanel(PropertyValueModel selectionHolder, ClassRepositoryHolder classRepositoryHolder, Filter classNameFilter, WorkbenchContextHolder contextHolder) {
        TransformationPropertyValueModel selectionHolderWrapper = new TransformationPropertyValueModel(selectionHolder, new ClassDescriptionTransformer(classRepositoryHolder));
        CombinedClassDescriptionRepositoryFactory cdrf = new CombinedClassDescriptionRepositoryFactory(classRepositoryHolder, classNameFilter);
        ClassDescriptionAdapter cda = ClassDescriptionClassDescriptionAdapter.instance();
        return new ClassChooserPanel(selectionHolderWrapper, cdrf, cda, contextHolder);
    }

    public static ClassChooserPanel buildPanel(PropertyValueModel selectionHolder, ClassRepositoryHolder classRepositoryHolder, Filter classNameFilter, JLabel label, WorkbenchContextHolder contextHolder) {
        TransformationPropertyValueModel selectionHolderWrapper = new TransformationPropertyValueModel(selectionHolder, new ClassDescriptionTransformer(classRepositoryHolder));
        CombinedClassDescriptionRepositoryFactory cdrf = new CombinedClassDescriptionRepositoryFactory(classRepositoryHolder, classNameFilter);
        ClassDescriptionAdapter cda = ClassDescriptionClassDescriptionAdapter.instance();
        return new ClassChooserPanel(selectionHolderWrapper, cdrf, cda, label, contextHolder);
    }

    public static ClassChooserPanel buildPanel(PropertyValueModel selectionHolder, ClassRepositoryHolder classRepositoryHolder, Filter classNameFilter, JLabel label, WorkbenchContextHolder contextHolder, String buttonKey) {
        TransformationPropertyValueModel selectionHolderWrapper = new TransformationPropertyValueModel(selectionHolder, new ClassDescriptionTransformer(classRepositoryHolder));
        CombinedClassDescriptionRepositoryFactory cdrf = new CombinedClassDescriptionRepositoryFactory(classRepositoryHolder, classNameFilter);
        ClassDescriptionAdapter cda = ClassDescriptionClassDescriptionAdapter.instance();
        return new ClassChooserPanel(selectionHolderWrapper, cdrf, cda, label, contextHolder, buttonKey);
    }

    public static Filter buildDeclarableReferenceFilter() {
        Filter declarable = ClassChooserTools.buildDeclarableFilter();
        Filter reference = ClassChooserTools.buildReferenceFilter();
        return new ANDFilter(declarable, reference);
    }

    public static Filter buildDeclarableNonVoidFilter() {
        Filter declarable = ClassChooserTools.buildDeclarableFilter();
        Filter nonVoid = ClassChooserTools.buildNonVoidFilter();
        return new ANDFilter(declarable, nonVoid);
    }

    public static Filter buildDeclarableFilter() {
        return new Filter(){

            public boolean accept(Object o) {
                return ClassTools.classNamedIsDeclarable((String)((String)o));
            }

            public String toString() {
                return "declarable filter";
            }
        };
    }

    public static Filter buildReferenceFilter() {
        return new Filter(){

            public boolean accept(Object o) {
                return ClassTools.classNamedIsReference((String)((String)o));
            }

            public String toString() {
                return "reference filter";
            }
        };
    }

    public static Filter buildNonVoidFilter() {
        return new Filter(){

            public boolean accept(Object o) {
                return !o.equals("void");
            }

            public String toString() {
                return "non-void filter";
            }
        };
    }

    public static class ClassDescriptionTransformer
    implements BidiTransformer {
        private ClassRepositoryHolder classRepositoryHolder;

        public ClassDescriptionTransformer(ClassRepositoryHolder classRepositoryHolder) {
            this.classRepositoryHolder = classRepositoryHolder;
        }

        public Object transform(Object o) {
            return o;
        }

        public Object reverseTransform(Object o) {
            return o == null ? null : this.classRepositoryHolder.getClassRepository().typeNamed(((ClassDescription)o).getName());
        }
    }
}

