/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml;

import java.awt.Component;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlFieldTransformerAssociation;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.FieldTransformerAssociationEditingDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.XmlFieldTransformerAssociationEditingPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;

public final class XmlFieldTransformerAssociationEditingDialog
extends FieldTransformerAssociationEditingDialog {
    public static void promptToAddFieldTransformerAssociation(MWXmlTransformationMapping transformationMapping, WorkbenchContext context) {
        MWXmlFieldTransformerAssociation association = transformationMapping.buildEmptyFieldTransformerAssociation();
        XmlFieldTransformerAssociationEditor editor = new XmlFieldTransformerAssociationEditor(association);
        XmlFieldTransformerAssociationEditingDialog dialog = new XmlFieldTransformerAssociationEditingDialog(editor, context);
        dialog.show();
        if (dialog.wasConfirmed()) {
            editor.commit();
            transformationMapping.addFieldTransformerAssociation((MWFieldTransformerAssociation)association);
        }
    }

    public static void promptToEditFieldTransformerAssociation(MWXmlFieldTransformerAssociation association, WorkbenchContext context) {
        XmlFieldTransformerAssociationEditor editor = new XmlFieldTransformerAssociationEditor(association);
        XmlFieldTransformerAssociationEditingDialog dialog = new XmlFieldTransformerAssociationEditingDialog(editor, context);
        dialog.show();
        if (dialog.wasConfirmed()) {
            editor.commit();
        }
    }

    private XmlFieldTransformerAssociationEditingDialog(XmlFieldTransformerAssociationEditor associationEditor, WorkbenchContext context) {
        super(associationEditor, context);
    }

    @Override
    protected void initialize(FieldTransformerAssociationEditingDialog.FieldTransformerAssociationEditor associationEditor) {
        super.initialize(associationEditor);
        this.associationEditor().xpathHolder().addPropertyChangeListener("value", this.validatingListener);
    }

    @Override
    protected Component buildMainPanel() {
        return new XmlFieldTransformerAssociationEditingPanel(this.associationEditor(), this.getWorkbenchContext());
    }

    @Override
    protected void updateMessage() {
        super.updateMessage();
        if (this.associationEditor().xpath().equals("")) {
            this.setErrorMessageKey("FIELD_TRANSFORMER_ASSOCIATION_EDITING_DIALOG.NULL_XPATH_ERROR");
        }
        if (this.associationEditor().xpathIsDuplicate()) {
            this.setWarningMessageKey("FIELD_TRANSFORMER_ASSOCIATION_EDITING_DIALOG.DUPLICATE_XPATH_WARNING");
        }
    }

    @Override
    protected void prepareToShow() {
        this.pack();
        this.setSize(Math.max(600, this.getWidth()), this.getHeight());
        this.setLocationRelativeTo(this.getParent());
    }

    private XmlFieldTransformerAssociationEditor associationEditor() {
        return (XmlFieldTransformerAssociationEditor)this.associationEditor;
    }

    private static class XmlFieldTransformerAssociationEditor
    extends FieldTransformerAssociationEditingDialog.AbstractFieldTransformerAssociationEditor
    implements XmlFieldTransformerAssociationEditingPanel.XmlFieldTransformerAssociationSpec {
        private ValueModel xmlFieldHolder;
        private BufferedPropertyValueModel xpathHolder;
        private BufferedPropertyValueModel.Trigger xpathTrigger = new BufferedPropertyValueModel.Trigger();

        protected XmlFieldTransformerAssociationEditor(MWXmlFieldTransformerAssociation association) {
            super((MWFieldTransformerAssociation)association);
        }

        private MWXmlFieldTransformerAssociation association() {
            return (MWXmlFieldTransformerAssociation)this.association;
        }

        private MWXmlTransformationMapping transformationMapping() {
            return (MWXmlTransformationMapping)this.association().getMapping();
        }

        @Override
        public ValueModel xmlFieldHolder() {
            if (this.xmlFieldHolder == null) {
                this.xmlFieldHolder = this.buildXmlFieldHolder();
            }
            return this.xmlFieldHolder;
        }

        private PropertyValueModel buildXmlFieldHolder() {
            return new PropertyAspectAdapter("field", (Model)this.association()){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWXmlFieldTransformerAssociation)this.subject).getXmlField();
                }
            };
        }

        public MWXmlField xmlField() {
            return (MWXmlField)this.xmlFieldHolder.getValue();
        }

        @Override
        public PropertyValueModel xpathHolder() {
            if (this.xpathHolder == null) {
                this.xpathHolder = this.buildXpathHolder();
            }
            return this.xpathHolder;
        }

        private BufferedPropertyValueModel buildXpathHolder() {
            return new BufferedPropertyValueModel(this.buildInternalXpathHolder(), this.xpathTrigger);
        }

        private PropertyValueModel buildInternalXpathHolder() {
            return new PropertyAspectAdapter(this.xmlFieldHolder(), "xpath"){

                @Override
                protected Object getValueFromSubject() {
                    return ((MWXmlField)this.subject).getXpath();
                }

                @Override
                protected void setValueOnSubject(Object value) {
                    ((MWXmlField)this.subject).setXpath((String)value);
                }
            };
        }

        public String xpath() {
            return (String)this.xpathHolder.getValue();
        }

        public boolean xpathIsDuplicate() {
            return this.association().duplicateXpath(this.xpath());
        }

        @Override
        public void commit() {
            super.commit();
            this.xpathTrigger.accept();
        }
    }
}

