/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWProxyIndirectionMapping;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

public final class ProxyIndirectionPanel
extends AbstractSubjectPanel {
    public ProxyIndirectionPanel(ValueModel proxyIndirectionMappingHolder, ApplicationContext context) {
        super((LayoutManager)new BorderLayout(10, 0), proxyIndirectionMappingHolder, context);
    }

    private JComponent buildIndirectionPane() {
        JPanel pane = new JPanel(new BorderLayout(10, 0));
        PropertyValueModel valueHolder = this.buildIndirectionTypeBooleanHolder();
        JRadioButton valueHolderRadioButton = this.buildRadioButton("PROXY_INDIRECTION_PANEL_VALUE_HOLDER_RADIO_BUTTON", this.buildValueHolderRadioButtonAdapter(valueHolder));
        JRadioButton proxyRadioButton = this.buildRadioButton("PROXY_INDIRECTION_PANEL_PROXY_RADIO_BUTTON", this.buildTransparentRadioButtonAdapter(valueHolder));
        pane.add((Component)valueHolderRadioButton, "Before");
        pane.add((Component)proxyRadioButton, "Center");
        new ComponentEnabler((ValueModel)this.buildIndirectionTypeEnablerHolder(), pane.getComponents());
        return pane;
    }

    private PropertyValueModel buildIndirectionTypeBooleanHolder() {
        return new TransformationPropertyValueModel(this.buildIndirectionTypeHolder()){

            @Override
            protected Object transform(Object value) {
                if ("value-holder-indirection".equals(value)) {
                    return Boolean.TRUE;
                }
                if ("proxy-indirection".equals(value)) {
                    return Boolean.FALSE;
                }
                return null;
            }
        };
    }

    private PropertyValueModel buildIndirectionTypeEnablerHolder() {
        return new TransformationPropertyValueModel(this.buildIndirectionTypeHolder()){

            @Override
            protected Object transform(Object value) {
                return !"no-indirection".equals(value);
            }
        };
    }

    private PropertyValueModel buildIndirectionTypeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "indirection"){

            @Override
            protected Object getValueFromSubject() {
                MWProxyIndirectionMapping mapping = (MWProxyIndirectionMapping)this.subject;
                if (mapping.usesValueHolderIndirection()) {
                    return "value-holder-indirection";
                }
                if (mapping.usesProxyIndirection()) {
                    return "proxy-indirection";
                }
                return "no-indirection";
            }

            @Override
            protected void setValueOnSubject(Object value) {
                MWProxyIndirectionMapping mapping = (MWProxyIndirectionMapping)this.subject;
                if (Boolean.TRUE.equals(value)) {
                    mapping.setUseValueHolderIndirection();
                } else {
                    mapping.setUseProxyIndirection();
                }
            }
        };
    }

    private ButtonModel buildTransparentRadioButtonAdapter(PropertyValueModel valueHolder) {
        return new RadioButtonModelAdapter(valueHolder, Boolean.FALSE);
    }

    private ButtonModel buildUseIndirectionCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildUseIndirectionHolder());
    }

    private PropertyValueModel buildUseIndirectionHolder() {
        PropertyAspectAdapter adapter = new PropertyAspectAdapter(this.getSubjectHolder(), "indirection"){

            @Override
            protected Object getValueFromSubject() {
                MWProxyIndirectionMapping mapping = (MWProxyIndirectionMapping)this.subject;
                if (mapping.usesValueHolderIndirection()) {
                    return "indirection";
                }
                if (mapping.usesProxyIndirection()) {
                    return "proxy-indirection";
                }
                return "no-indirection";
            }

            @Override
            protected void setValueOnSubject(Object value) {
                MWProxyIndirectionMapping mapping = (MWProxyIndirectionMapping)this.subject;
                if (Boolean.TRUE.equals(value) && mapping.usesNoIndirection()) {
                    mapping.setUseValueHolderIndirection();
                } else if (Boolean.FALSE.equals(value) && !mapping.usesNoIndirection()) {
                    mapping.setUseNoIndirection();
                }
            }
        };
        return new TransformationPropertyValueModel(adapter){

            @Override
            protected Object transform(Object value) {
                return !"no-indirection".equals(value);
            }
        };
    }

    private ButtonModel buildValueHolderRadioButtonAdapter(PropertyValueModel valueHolder) {
        return new RadioButtonModelAdapter(valueHolder, Boolean.TRUE);
    }

    @Override
    protected void initializeLayout() {
        JCheckBox useIndirectionCheckBox = this.buildCheckBox("INDIRECTABLE_COLLECTION_USE_INDIRECTION_CHECK_BOX", this.buildUseIndirectionCheckBoxAdapter());
        GroupBox groupBox = new GroupBox(useIndirectionCheckBox, this.buildIndirectionPane());
        this.add((Component)groupBox, "Center");
        this.addHelpTopicId(this, "mapping.proxy.indirection");
    }
}

